/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers.extensionlinks;

import com.atlassian.pocketknife.api.logging.Log;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressConfiguration;
import com.radiantminds.roadmap.common.handlers.extensionlinks.InvalidLinkException;
import javax.annotation.Nonnull;

public interface AddExtensionLinkRequest {
    @Nonnull
    public String getKey();

    @Nonnull
    public String getLink();

    public ProgressConfiguration getProgressConfiguration();

    public static class Impl
    implements AddExtensionLinkRequest {
        private static final Log LOGGER = Log.with(AddExtensionLinkRequest.class);
        private final String key;
        private final String link;
        private final ProgressConfiguration progressConfiguration;

        private Impl(String key, String link, ProgressConfiguration progressConfiguration) {
            this.key = key;
            this.link = link;
            this.progressConfiguration = progressConfiguration;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getLink() {
            return this.link;
        }

        @Override
        public ProgressConfiguration getProgressConfiguration() {
            return this.progressConfiguration;
        }

        public String toString() {
            return "AddExtensionLinkRequest.Impl{, link='" + this.link + '\'' + '}';
        }

        public static AddExtensionLinkRequest create(String key, String link, ProgressConfiguration progressConfiguration) throws InvalidLinkException {
            if (key == null) {
                LOGGER.warn("key of link request is null", new Object[0]);
                throw new InvalidLinkException();
            }
            if (link == null) {
                LOGGER.warn("link of link request is null", new Object[0]);
                throw new InvalidLinkException();
            }
            return new Impl(key, link, progressConfiguration);
        }
    }
}

