/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers.releases.link;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtension;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtensionLinkData;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtensionsDataRetrieval;
import com.radiantminds.roadmap.common.extensions.versions.VersionExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.handlers.extensionlinks.AddExtensionLinkRequest;
import com.radiantminds.roadmap.common.handlers.extensionlinks.BaseExtensionLinkHandler;
import com.radiantminds.roadmap.common.handlers.extensionlinks.InvalidLinkException;
import com.radiantminds.roadmap.common.handlers.extensionlinks.SecureExtensionLinkHandler;
import com.radiantminds.roadmap.common.rest.entities.releases.links.RestReleaseExtensionLinkResponse;
import com.radiantminds.roadmap.common.rest.entities.releases.links.RestReleaseExtensionLinks;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class ReleaseExtensionLinkHandler
extends BaseExtensionLinkHandler<IRelease, PortfolioReleasePersistence> {
    private static final Log LOGGER = Log.with(ReleaseExtensionLinkHandler.class);
    private final ReleaseExtensionsDataRetrieval releaseDataEnrichment;
    private final PortfolioExtensionLinkPersistence extensionLinkPersistence;
    private final VersionExtension versionExtension;

    ReleaseExtensionLinkHandler(PortfolioReleasePersistence releasePersistence, PortfolioExtensionLinkPersistence extensionLinkPersistence, VersionExtension releaseExtension, ReleaseExtensionsDataRetrieval releaseDataEnrichment) {
        super(releasePersistence, extensionLinkPersistence);
        this.extensionLinkPersistence = extensionLinkPersistence;
        this.versionExtension = releaseExtension;
        this.releaseDataEnrichment = releaseDataEnrichment;
    }

    @Override
    protected void onBeforeAdd(String extendableId, AddExtensionLinkRequest addRequest, Class<IRelease> entityClazz) throws InvalidLinkException, SQLException {
        String key = addRequest.getKey();
        if (!"release".equals(key)) {
            LOGGER.warn("encountered illegal link key for release: ", key);
            throw new InvalidLinkException();
        }
        if (this.versionExtension == null) {
            return;
        }
        List<IExtensionLink> linksOnItem = this.extensionLinkPersistence.getLinksForTarget(AORelease.class, extendableId);
        if (linksOnItem == null || linksOnItem.size() == 0) {
            return;
        }
        String requestedVersionId = addRequest.getLink();
        Long projectOfVersion = this.getProjectIdForVersionId(requestedVersionId);
        if (projectOfVersion == null) {
            return;
        }
        for (IExtensionLink link : linksOnItem) {
            Long projectOfLink = this.getProjectIdForVersionId(link.getExtensionLink());
            if (projectOfLink == null || !projectOfLink.equals(projectOfVersion)) continue;
            LOGGER.info("Removing conflicting link for project id " + projectOfLink, new Object[0]);
            this.extensionLinkPersistence.removeExtensionLink(AORelease.class, extendableId, link.getExtensionKey(), link.getExtensionLink());
        }
    }

    private Long getProjectIdForVersionId(String versionId) {
        if (versionId == null) {
            return null;
        }
        try {
            Long longVersionId = Long.parseLong(versionId);
            return this.versionExtension.getProjectIdForVersion(longVersionId);
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to get project if for version '%s'", versionId);
            LOGGER.exception(ex, Log.LogLevel.WARN);
            return null;
        }
    }

    @Override
    protected Object generateResponseEntity(EntityContext<IRelease> entityContext, Collection<AddExtensionLinkRequest> links) throws Exception {
        ArrayList enrichedLinks = Lists.newArrayList();
        for (AddExtensionLinkRequest link : links) {
            RestReleaseExtensionLinkResponse response = ReleaseExtensionLinkHandler.createEnrichedLink(this.releaseDataEnrichment, link.getKey(), link.getLink());
            if (response == null) continue;
            enrichedLinks.add(response);
        }
        return new RestReleaseExtensionLinks(enrichedLinks);
    }

    public static SecureExtensionLinkHandler<IRelease> createSecureReleaseExtensionLinkService(SecuredInvocationHandlerFactory handlerFactory, PortfolioReleasePersistence releasePersistence, PortfolioExtensionLinkPersistence extensionLinkPersistence, ReleaseExtension releaseExtension, VersionExtension versionExtension) {
        LOGGER.debug("create new instance", new Object[0]);
        return handlerFactory.createProxy(SecureExtensionLinkHandler.class, new ReleaseExtensionLinkHandler(releasePersistence, extensionLinkPersistence, versionExtension, ReleaseExtensionsDataRetrieval.create(releaseExtension)), releasePersistence);
    }

    @Nullable
    public static RestReleaseExtensionLinkResponse createEnrichedLink(ReleaseExtensionsDataRetrieval releaseDataEnrichment, String key, String value) throws Exception {
        RestReleaseExtensionLinkResponse link = new RestReleaseExtensionLinkResponse(key, value);
        ReleaseExtensionLinkData data = releaseDataEnrichment.getExtensionLinkDataForSingleLink(value);
        if (data == null) {
            return null;
        }
        link.enrich(data);
        return link;
    }
}

