/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers.sync;

import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.analytics.AnalyticsExtension;
import com.radiantminds.roadmap.common.extensions.releases.ReleaseExtension;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.sync.SyncConfiguration;
import com.radiantminds.roadmap.common.handlers.sync.SyncOperationResult;
import com.radiantminds.roadmap.common.handlers.sync.SyncResult;
import com.radiantminds.roadmap.common.handlers.sync.SyncServiceHandler;
import com.radiantminds.roadmap.common.handlers.sync.ValidatedSyncConfiguration;
import com.radiantminds.roadmap.common.handlers.sync.releases.ReleaseSyncConfiguration;
import com.radiantminds.roadmap.common.handlers.sync.releases.ReleaseSyncServiceHandler;
import com.radiantminds.roadmap.common.handlers.sync.releases.ReleaseSyncServiceHandlerImpl;
import com.radiantminds.roadmap.common.handlers.sync.workitems.ValidatedWorkItemSyncConfiguration;
import com.radiantminds.roadmap.common.handlers.sync.workitems.WorkItemSyncServiceHandler;
import com.radiantminds.roadmap.common.handlers.sync.workitems.WorkItemSyncServiceHandlerImpl;
import com.radiantminds.roadmap.common.scheduling.Scheduling;

public class SyncServiceHandlerImpl
implements SyncServiceHandler {
    private WorkItemSyncServiceHandler workItemSyncServiceHandler;
    private ReleaseSyncServiceHandler releaseSyncServiceHandler;

    public SyncServiceHandlerImpl(AnalyticsExtension analyticsExtension, PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioStagePersistence stagePersistence, PortfolioReleasePersistence releasePersistence, PortfolioExtensionLinkPersistence linkPersistence, WorkItemExtension workItemExtension, ReleaseExtension releaseExtension, Scheduling scheduling) {
        this.workItemSyncServiceHandler = new WorkItemSyncServiceHandlerImpl(planPersistence, workItemPersistence, stagePersistence, linkPersistence, analyticsExtension, workItemExtension, scheduling);
        this.releaseSyncServiceHandler = ReleaseSyncServiceHandlerImpl.createInstance(releasePersistence, linkPersistence, releaseExtension, scheduling);
    }

    @Override
    public SyncResult sync(EntityContext<IPlan> entityContext, SyncConfiguration rawConfig) throws Exception {
        ValidatedSyncConfiguration configuration = ValidatedSyncConfiguration.create(rawConfig);
        final SyncOperationResult workItemSyncResult = this.workItemSyncServiceHandler.syncWorkitems(entityContext, (ValidatedWorkItemSyncConfiguration)configuration.getWorkItemSyncConfiguration().orNull());
        final SyncOperationResult releaseSyncResult = this.releaseSyncServiceHandler.syncReleases(entityContext, (ReleaseSyncConfiguration)configuration.getReleaseSyncConfiguration().orNull());
        return new SyncResult(){

            @Override
            public SyncOperationResult getReleaseSyncResult() {
                return releaseSyncResult;
            }

            @Override
            public SyncOperationResult getWorkItemSyncResult() {
                return workItemSyncResult;
            }
        };
    }
}

