/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.common;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.WorkItemMoveResult;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="workItems")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestWorkItemMoveData {
    @XmlElement
    RestWorkItem current;
    @XmlElement
    RestWorkItem newParent;
    @XmlElement
    RestWorkItem oldParent;
    @XmlElement
    List<RestWorkItem> modifiedLeaves;

    @Deprecated
    private RestWorkItemMoveData() {
    }

    public RestWorkItemMoveData(RestWorkItem current, RestWorkItem newParent, RestWorkItem oldParent, List<RestWorkItem> modifiedLeaves) {
        this.current = current;
        this.oldParent = oldParent;
        this.newParent = newParent;
        this.modifiedLeaves = modifiedLeaves;
    }

    public static RestWorkItemMoveData createFrom(WorkItemMoveResult result) {
        List<RestWorkItem> modifiedLeaves = RestWorkItemMoveData.createModifiedLeaves(result);
        return new RestWorkItemMoveData(RestWorkItemMoveData.createVersionedRestItem(result.getWorkItemId(), (Long)result.getWorkItemVersion().orNull()), RestWorkItemMoveData.createVersionedRestItem(result.getNewParentId(), (Long)result.getNewParentVersion().orNull()), RestWorkItemMoveData.createVersionedRestItem(result.getOldParentId(), (Long)result.getOldParentVersion().orNull()), modifiedLeaves);
    }

    private static List<RestWorkItem> createModifiedLeaves(WorkItemMoveResult result) {
        ArrayList modified = Lists.newArrayList();
        String themeId = (String)result.getInheritedThemeId().orNull();
        if (themeId == null) {
            return modified;
        }
        for (String id : result.getThemeInheritingItemIds()) {
            modified.add(RestWorkItemMoveData.createThemedWorkItem(id, themeId));
        }
        return modified;
    }

    private static RestWorkItem createThemedWorkItem(String id, String themeId) {
        RestWorkItem item = RestWorkItem.createForEnrichment(id);
        item.setThemeId(themeId);
        return item;
    }

    private static RestWorkItem createVersionedRestItem(String id, @Nullable Long version) {
        RestWorkItem item = RestWorkItem.createForEnrichment(id);
        item.setId(id);
        item.setVersion(version);
        return item;
    }
}

