/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.common;

import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

@XmlRootElement(name="result")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlSeeAlso(value={ModificationResult.class})
public class Result {
    @XmlElement
    private Boolean planVersionConflict;
    @XmlElement
    private Long planVersion;
    @XmlElement
    private Long schedulingVersion;
    @XmlElement
    private Object data;
    @XmlElement
    private Object[] collection;

    private Result() {
    }

    public static Result from(Object result) {
        if (result != null && result.getClass().isArray()) {
            throw new IllegalArgumentException("Use array implementation of 'from'.");
        }
        Result retVal = new Result();
        retVal.data = result;
        return retVal;
    }

    public static Result from(Long planVersion, Long schedulingVersion, Object result) {
        if (result != null && result.getClass().isArray()) {
            throw new IllegalArgumentException("Use array implementation of 'from'.");
        }
        Result retVal = new Result();
        retVal.data = result;
        retVal.planVersion = planVersion;
        retVal.schedulingVersion = schedulingVersion;
        return retVal;
    }

    public static Result from(Object[] entities) {
        Result retVal = new Result();
        retVal.collection = entities;
        return retVal;
    }

    public static Result from(Long planVersion, Long schedulingVersion, Object[] entities) {
        Result retVal = new Result();
        retVal.collection = entities;
        retVal.planVersion = planVersion;
        retVal.schedulingVersion = schedulingVersion;
        return retVal;
    }

    public static Result from(Long planVersion, Long schedulingVersion) {
        Result retVal = new Result();
        retVal.data = null;
        retVal.planVersion = planVersion;
        retVal.schedulingVersion = schedulingVersion;
        return retVal;
    }

    public <TData> TData getData() {
        return (TData)this.data;
    }

    public <TData> TData getData(Class<TData> clazz) {
        if (this.data == null) {
            return null;
        }
        return clazz.cast(this.data);
    }

    public <TData> TData[] getCollection(Class<TData[]> clazz) {
        if (this.collection == null || this.collection.length == 0) {
            return null;
        }
        return Arrays.copyOf(this.collection, this.collection.length, clazz);
    }

    public Long getPlanVersion() {
        return this.planVersion;
    }

    public boolean hasPlanVersionConflict() {
        return this.planVersionConflict != null && this.planVersionConflict != false;
    }

    public void setPlanVersionConflict(Boolean planConflict) {
        this.planVersionConflict = planConflict;
    }
}

