/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.people;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.people.IAvailability;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.data.entities.people.IResource;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.rest.entities.common.BaseRestRankable;
import com.radiantminds.roadmap.common.rest.entities.people.RestAvailability;
import com.radiantminds.roadmap.common.rest.services.common.SchedulingRelevantPatch;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="resource")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestResource
extends BaseRestRankable
implements IResource {
    @XmlElement
    private String personId;
    @XmlElement
    @SchedulingRelevantPatch
    private Double availability;
    @XmlElement
    private List<RestAvailability> availabilityIntervals;
    private ITeam team;
    private IPerson person;

    @Deprecated
    private RestResource() {
    }

    public RestResource(String id, String personIdentifier) {
        super(id);
        this.personId = personIdentifier;
    }

    public RestResource(String id) {
        super(id);
    }

    public RestResource(IResource resource) {
        super(resource);
        this.team = resource.getTeam();
        this.person = resource.getPerson();
        this.availability = resource.getAvailability();
        this.availabilityIntervals = Lists.newArrayList();
        for (IAvailability interval : resource.getAvailabilityIntervals()) {
            this.availabilityIntervals.add(new RestAvailability(interval));
        }
        if (resource.getPerson() != null) {
            this.personId = resource.getPerson().getId();
        }
    }

    @Override
    public Double getAvailability() {
        return this.availability;
    }

    @Override
    public String getPersonId() {
        return this.personId;
    }

    @Override
    public void setAvailability(Double value) {
        this.availability = value;
    }

    @Override
    public IPerson getPerson() {
        return this.person;
    }

    @Override
    public void setPerson(IPerson person) {
        this.person = person;
    }

    @Override
    public ITeam getTeam() {
        return this.team;
    }

    @Override
    public void setTeam(ITeam team) {
        this.team = team;
    }

    @Override
    public List<IAvailability> getAvailabilityIntervals() {
        if (this.availabilityIntervals != null) {
            return Lists.newArrayList(this.availabilityIntervals);
        }
        return Lists.newArrayList();
    }

    public void setAvailabilityIntervals(List<RestAvailability> availabilityIntervals) {
        this.availabilityIntervals = availabilityIntervals;
    }
}

