/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.people;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.people.IResource;
import com.radiantminds.roadmap.common.data.entities.people.ISprint;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.entities.people.IterationStartType;
import com.radiantminds.roadmap.common.data.entities.people.PlanningMode;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.rest.entities.common.BaseRestRankableDescribable;
import com.radiantminds.roadmap.common.rest.entities.people.RestResource;
import com.radiantminds.roadmap.common.rest.entities.people.RestSprint;
import com.radiantminds.roadmap.common.rest.services.common.SchedulingRelevantPatch;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="team")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestTeam
extends BaseRestRankableDescribable
implements ITeam {
    @XmlElement(name="resources")
    private List<RestResource> resources;
    @XmlElement(name="sprints")
    private List<RestSprint> sprints;
    @XmlElement
    @SchedulingRelevantPatch
    private PlanningMode planningMode;
    @SchedulingRelevantPatch
    @XmlElement
    private IterationStartType iterationStartType;
    @XmlElement
    @SchedulingRelevantPatch
    private Integer weeksPerSprint;
    @XmlElement
    private Double velocity;
    @XmlElement
    private Double incrementalAdjustment;
    @XmlElement
    private Boolean autoAdjustToAbsences;
    private IPlan plan;
    private List<IWorkItem> workItems;
    private Map<String, RestResource> resourceMap;

    @Deprecated
    private RestTeam() {
    }

    public RestTeam(String id, String title, String description) {
        super(id, title, description);
        this.setResources(Lists.newArrayList());
        this.setSprints(Lists.newArrayList());
    }

    public RestTeam(ITeam team) {
        super(team);
        this.setResources(team.getResources());
        this.setSprints(team.getSprints());
        this.plan = team.getPlan();
        this.workItems = team.getWorkItems();
        this.planningMode = team.getPlanningMode();
        this.iterationStartType = team.getIterationStartType();
        this.weeksPerSprint = team.getWeeksPerSprint();
        this.velocity = team.getVelocity();
        this.autoAdjustToAbsences = team.getAutoAdjustToAbsences();
        this.incrementalAdjustment = team.getIncrementalAdjustment();
    }

    @Override
    public List<IResource> getResources() {
        return this.resources != null ? Lists.newArrayList(this.resources) : null;
    }

    private void setResources(List<IResource> resources) {
        this.resourceMap = Maps.newHashMap();
        this.resources = Lists.newArrayList();
        for (IResource resource : resources) {
            RestResource restResource = new RestResource(resource);
            this.resources.add(restResource);
            this.resourceMap.put(restResource.getId(), restResource);
        }
    }

    @Override
    public List<ISprint> getSprints() {
        return this.sprints != null ? Lists.newArrayList(this.sprints) : null;
    }

    private void setSprints(List<ISprint> sprints) {
        this.sprints = Lists.newArrayList();
        for (ISprint sprint : sprints) {
            RestSprint restSprint = new RestSprint(sprint);
            this.sprints.add(restSprint);
        }
    }

    @Override
    public IPlan getPlan() {
        return this.plan;
    }

    @Override
    public void setPlan(IPlan plan) {
        this.plan = plan;
    }

    @Override
    public void setPlanningMode(PlanningMode mode) {
        this.planningMode = mode;
    }

    @Override
    public PlanningMode getPlanningMode() {
        return this.planningMode;
    }

    @Override
    public IterationStartType getIterationStartType() {
        return this.iterationStartType;
    }

    @Override
    public void setIterationStartType(IterationStartType iterationStartType) {
        this.iterationStartType = iterationStartType;
    }

    @Override
    public List<IWorkItem> getWorkItems() {
        return this.workItems;
    }

    @Override
    public Integer getWeeksPerSprint() {
        return this.weeksPerSprint;
    }

    @Override
    public void setWeeksPerSprint(Integer weeksPerSprint) {
        this.weeksPerSprint = weeksPerSprint;
    }

    @Override
    public Double getVelocity() {
        return this.velocity;
    }

    @Override
    public void setVelocity(Double velocity) {
        this.velocity = velocity;
    }

    @Override
    public Double getIncrementalAdjustment() {
        return this.incrementalAdjustment;
    }

    @Override
    public void setIncrementalAdjustment(Double incrementalAdjustment) {
        this.incrementalAdjustment = incrementalAdjustment;
    }

    @Override
    public Boolean getAutoAdjustToAbsences() {
        return this.autoAdjustToAbsences;
    }

    @Override
    public void setAutoAdjustToAbsences(Boolean autoAdjustToAbsences) {
        this.autoAdjustToAbsences = autoAdjustToAbsences;
    }

    public void addRestResource(RestResource resource) {
        if (this.resources == null) {
            this.resources = Lists.newArrayList();
        }
        if (this.resourceMap == null) {
            this.resourceMap = Maps.newHashMap();
        }
        this.resourceMap.put(resource.getId(), resource);
        this.resources.add(resource);
    }

    public void addRestSprint(RestSprint sprint) {
        if (this.sprints == null) {
            this.sprints = Lists.newArrayList();
        }
        this.sprints.add(sprint);
    }
}

