/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.releases;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.rest.entities.common.BaseRestRankableDescribable;
import com.radiantminds.roadmap.common.rest.entities.releases.links.RestReleaseExtensionLinkResponse;
import com.radiantminds.roadmap.common.rest.services.common.SchedulingRelevantPatch;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="release")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestRelease
extends BaseRestRankableDescribable
implements IRelease {
    @XmlElement
    @SchedulingRelevantPatch
    private Long fixedEndDate;
    @XmlElement
    @SchedulingRelevantPatch
    private Long fixedStartDate;
    @XmlElement
    @SchedulingRelevantPatch
    private Long deltaStartDate;
    @XmlElement
    @SchedulingRelevantPatch
    private Boolean asEarlyAsPossible;
    @XmlElement
    private String primaryVersion;
    @XmlElement
    private Boolean isLater;
    @XmlElement
    private List<RestReleaseExtensionLinkResponse> links;
    private IStream stream;
    private List<IWorkItem> workItems;

    @Deprecated
    private RestRelease() {
    }

    public RestRelease(String id, String title, String description, Long fixedEndDate, Long fixedStartDate, Long deltaStartDate, String primaryVersion) {
        super(id, title, description);
        this.fixedStartDate = fixedStartDate;
        this.fixedEndDate = fixedEndDate;
        this.deltaStartDate = deltaStartDate;
        this.primaryVersion = primaryVersion;
    }

    public RestRelease(IRelease release) {
        super(release);
        Long fixedStartDate = (Long)release.getFixedStartDate().orNull();
        Long deltaStartDate = (Long)release.getDeltaStartDate().orNull();
        this.fixedEndDate = (Long)release.getFixedEndDate().orNull();
        this.fixedStartDate = fixedStartDate;
        this.deltaStartDate = deltaStartDate;
        this.primaryVersion = release.getPrimaryVersion();
        this.stream = release.getStream();
        this.workItems = release.getWorkItems();
        this.isLater = release.getIsLaterRelease();
    }

    @Override
    public String getPrimaryVersion() {
        return this.primaryVersion;
    }

    @Override
    public void setPrimaryVersion(String version) {
        this.primaryVersion = version;
    }

    @Override
    public Optional<Long> getFixedEndDate() {
        return Optional.fromNullable((Object)this.fixedEndDate);
    }

    @Override
    public void setFixedEndDate(Long date) {
        this.fixedEndDate = date;
    }

    @Override
    public Optional<Long> getFixedStartDate() {
        return Optional.fromNullable((Object)this.fixedStartDate);
    }

    @Override
    public void setFixedStartDate(Long date) {
        this.fixedStartDate = date;
    }

    @Override
    public Optional<Long> getDeltaStartDate() {
        return Optional.fromNullable((Object)this.deltaStartDate);
    }

    @Override
    public void setDeltaStartDate(Long delta) {
        this.deltaStartDate = delta;
    }

    public Optional<Boolean> getAsEarlyAsPossible() {
        return Optional.fromNullable((Object)this.asEarlyAsPossible);
    }

    @Override
    public List<IWorkItem> getWorkItems() {
        return this.workItems;
    }

    @Override
    public IStream getStream() {
        return this.stream;
    }

    @Override
    public void setStream(IStream stream) {
        this.stream = stream;
    }

    @Override
    public Boolean getIsLaterRelease() {
        return this.isLater;
    }

    @Override
    public void setIsLaterRelease(Boolean isLater) {
        this.isLater = isLater;
    }

    public void setIsLaterRelease(boolean isLater) {
        this.isLater = isLater;
    }

    @Override
    public boolean isFixedDurationRelease() {
        return this.fixedEndDate != null;
    }

    @Override
    public List<IExtensionLink> getExtensionLinks() {
        if (this.links != null) {
            return Collections.unmodifiableList(Lists.newArrayList(this.links));
        }
        return Collections.unmodifiableList(Lists.newArrayList());
    }

    @Override
    public void removeExtensionLink(IExtensionLink link) {
        if (this.links != null) {
            this.links.remove(link);
        }
    }

    public void addExtensionLink(RestReleaseExtensionLinkResponse link) {
        if (this.links == null) {
            this.links = Lists.newArrayList();
        }
        this.links.add(link);
    }
}

