/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.releases;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.rest.entities.common.BaseRestRankableDescribable;
import com.radiantminds.roadmap.common.rest.entities.releases.RestRelease;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="stream")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestStream
extends BaseRestRankableDescribable
implements IStream {
    @XmlElement
    private String shortName;
    @XmlElement
    private String color;
    @XmlElement
    private List<RestRelease> releases;
    @XmlElement
    private RestRelease laterRelease;
    @XmlElement
    private Set<String> teams;
    private IPlan plan;
    private LinkedHashMap<String, RestRelease> releaseMap;

    @Deprecated
    private RestStream() {
    }

    public RestStream(String id, String title, String description) {
        super(id, title, description);
    }

    public RestStream(IStream stream, PortfolioStreamPersistence streamPersistence) throws SQLException {
        super(stream);
        this.plan = stream.getPlan();
        this.color = stream.getColor();
        this.shortName = stream.getShortName();
        this.teams = streamPersistence.getRestrictedTeamIds(stream.getId());
        this.setLaterRelease(stream.getLaterRelease());
        this.setReleases(stream.getReleases());
    }

    @Override
    public String getColor() {
        return this.color;
    }

    @Override
    public void setColor(String color) {
        this.color = color;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Override
    public IRelease getLaterRelease() {
        return this.laterRelease;
    }

    public void setLaterRelease(IRelease release) {
        this.laterRelease = release instanceof RestRelease ? (RestRelease)release : new RestRelease(release);
    }

    @Override
    public List<IRelease> getReleases() {
        if (this.releases == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(this.releases);
    }

    @Override
    public Set<String> getTeams() {
        return (Set)Optional.fromNullable(this.teams).or((Object)Sets.newHashSet());
    }

    public void setTeams(Set<String> teams) {
        this.teams = teams;
    }

    public void addRelease(RestRelease release) {
        if (this.releases == null) {
            this.releases = Lists.newArrayList();
        }
        if (this.releaseMap == null) {
            this.releaseMap = Maps.newLinkedHashMap();
        }
        this.releases.add(release);
        this.releaseMap.put(release.getId(), release);
    }

    public void setReleases(List<IRelease> releases) {
        this.releases = Lists.newArrayList();
        this.releaseMap = Maps.newLinkedHashMap();
        for (IRelease release : releases) {
            RestRelease restRelease = release instanceof RestRelease ? (RestRelease)release : new RestRelease(release);
            this.releases.add(restRelease);
            this.releaseMap.put(restRelease.getId(), restRelease);
        }
    }

    @Override
    public IPlan getPlan() {
        return this.plan;
    }

    @Override
    public void setPlan(IPlan plan) {
        this.plan = plan;
    }

    @Override
    public boolean isDynamicStartStream() {
        if (this.releases == null || this.releases.isEmpty()) {
            return false;
        }
        return !this.releases.get(0).getFixedStartDate().isPresent();
    }
}

