/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.scheduling;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingAvailability;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingInterval;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingPerson;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingResource;
import com.radiantminds.roadmap.common.rest.entities.people.RestAbsence;
import com.radiantminds.roadmap.common.rest.entities.people.RestPresence;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="resource")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestResourceEntry {
    @XmlElement
    private String resourceId;
    @XmlElement
    private List<RestAbsence> absences;
    @XmlElement
    private List<RestPresence> presences;
    @XmlElement
    private List<RestAbsence> teamAbsences;
    @XmlElement
    private List<RestPresence> teamPresences;

    @Deprecated
    private RestResourceEntry() {
    }

    public RestResourceEntry(String id, SchedulingResource resource, SchedulingPerson person) {
        this.resourceId = id;
        this.absences = Lists.newArrayList();
        this.presences = Lists.newArrayList();
        this.teamPresences = Lists.newArrayList();
        this.teamAbsences = Lists.newArrayList();
        for (SchedulingInterval schedulingInterval : person.getAbsenceIntervals()) {
            RestAbsence restAbsence = new RestAbsence(schedulingInterval);
            restAbsence.setVersion(null);
            restAbsence.setId(null);
            restAbsence.setSortOrder(null);
            restAbsence.setDetails(null);
            this.absences.add(restAbsence);
        }
        for (SchedulingInterval schedulingInterval : person.getPresenceIntervals()) {
            RestPresence restPresence = new RestPresence(schedulingInterval);
            restPresence.setVersion(null);
            restPresence.setId(null);
            restPresence.setSortOrder(null);
            restPresence.setDetails(null);
            this.presences.add(restPresence);
        }
        if (resource.getAvailability() != null && resource.getAvailability() <= 0.0) {
            for (SchedulingAvailability schedulingAvailability : resource.getAvailabilityIntervals()) {
                if (schedulingAvailability.getAvailability() == null || !(schedulingAvailability.getAvailability() > 0.0)) continue;
                RestPresence presence = new RestPresence(null, null, null);
                presence.setStartDate(schedulingAvailability.getStartDate());
                presence.setEndDate(schedulingAvailability.getEndDate());
                presence.setTitle("Temporary availability");
                presence.setVersion(null);
                this.teamPresences.add(presence);
            }
        } else {
            for (SchedulingAvailability schedulingAvailability : resource.getAvailabilityIntervals()) {
                if (schedulingAvailability.getAvailability() != null && !(schedulingAvailability.getAvailability() <= 0.0)) continue;
                RestAbsence absence = new RestAbsence(null, null, null);
                absence.setStartDate(schedulingAvailability.getStartDate());
                absence.setEndDate(schedulingAvailability.getEndDate());
                absence.setTitle("Zero availability");
                absence.setVersion(null);
                this.teamAbsences.add(absence);
            }
        }
    }

    public String getId() {
        return this.resourceId;
    }
}

