/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.skills;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.skills.ISkill;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.rest.entities.common.BaseRestRankableDescribable;
import com.radiantminds.roadmap.common.rest.entities.skills.RestSkill;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="stage")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestStage
extends BaseRestRankableDescribable
implements IStage {
    @XmlElement
    private String color;
    @XmlElement(name="skills")
    private List<RestSkill> skills;
    @XmlElement
    private Double percentage;
    private IPlan parent;

    @Deprecated
    private RestStage() {
    }

    public RestStage(String id, String title, String description, String color, List<RestSkill> skills) {
        super(id, title, description);
        this.color = color;
        if (skills != null) {
            this.setSkills(Collections.unmodifiableList(skills));
        } else {
            this.setSkills(Lists.newArrayList());
        }
    }

    public RestStage(IStage stage) {
        super(stage);
        this.color = stage.getColor();
        this.skills = Lists.newArrayList();
        this.color = stage.getColor();
        this.percentage = stage.getPercentage();
        this.parent = stage.getPlan();
        this.setSkills(stage.getSkills());
    }

    @Override
    public String getColor() {
        return this.color;
    }

    @Override
    public void setColor(String color) {
        this.color = color;
    }

    @Override
    public Double getPercentage() {
        return this.percentage;
    }

    @Override
    public void setPercentage(Double percentage) {
        this.percentage = percentage;
    }

    @Override
    public List<ISkill> getSkills() {
        return Collections.unmodifiableList(this.skills != null ? this.skills : Lists.newArrayList());
    }

    @Override
    public IPlan getPlan() {
        return this.parent;
    }

    @Override
    public void setPlan(IPlan plan) {
        this.parent = plan;
    }

    public void addRestSkill(RestSkill skill) {
        this.skills.add(skill);
    }

    public void setSkills(List<ISkill> skills) {
        this.skills = Lists.newArrayList();
        for (ISkill skill : skills) {
            RestSkill skillToAdd = skill instanceof RestSkill ? (RestSkill)skill : new RestSkill(skill);
            this.skills.add(skillToAdd);
        }
    }
}

