/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.common;

import com.radiantminds.roadmap.common.data.entities.common.IIdentifiable;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.IEntityPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.entities.common.IReplanningAware;
import javax.ws.rs.core.Response;

public interface BaseOperationsServiceHandler<TEntityInterface extends IIdentifiable, TRestEntity extends TEntityInterface> {
    @AuthorizedPlanReadAccess(entityNeeded=true)
    public Response entryGet(EntityContext<TEntityInterface> var1, boolean var2, boolean var3, TransformEntityFunction<TEntityInterface, TRestEntity> var4) throws Exception;

    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response entryDelete(EntityContext<TEntityInterface> var1) throws Exception;

    @AuthorizedPlanUserAccess(incrementSchedulingVersion=VersionIncrementMode.Dynamic, entityNeeded=true)
    public Response update(EntityContext<TEntityInterface> var1, TRestEntity var2, boolean var3, UpdateEntityFunction<TEntityInterface, TRestEntity> var4, IncrementSchedulingVersionFunction<TRestEntity> var5) throws Exception;

    public static class Impl<TEntityInterface extends IIdentifiable, TRestEntity extends TEntityInterface>
    implements BaseOperationsServiceHandler<TEntityInterface, TRestEntity> {
        private final IEntityPersistence<TEntityInterface> persistence;

        public Impl(IEntityPersistence<TEntityInterface> persistence) {
            this.persistence = persistence;
        }

        @Override
        public Response entryGet(EntityContext<TEntityInterface> entityContext, boolean includeReplanning, boolean replanningAware, TransformEntityFunction<TEntityInterface, TRestEntity> func) throws Exception {
            TRestEntity restEntity = func.transform(entityContext.getEntity(), includeReplanning);
            if (replanningAware && !includeReplanning) {
                ((IReplanningAware)restEntity).nullifyReplanningData();
            }
            return entityContext.ok(restEntity);
        }

        @Override
        public Response entryDelete(EntityContext<TEntityInterface> entityContext) throws Exception {
            this.persistence.delete(entityContext.getEntityId(), false);
            return entityContext.ok();
        }

        @Override
        public Response update(EntityContext<TEntityInterface> entityContext, TRestEntity restEntity, boolean updateNullValues, UpdateEntityFunction<TEntityInterface, TRestEntity> updateFunction, IncrementSchedulingVersionFunction<TRestEntity> incrementSchedulingVersionFunction) throws Exception {
            Response updateResponse = updateFunction.apply(restEntity, entityContext.getEntity(), updateNullValues);
            if (incrementSchedulingVersionFunction.apply(restEntity)) {
                entityContext.setIncrementSchedulingVersion(true);
            }
            if (updateResponse != null) {
                return updateResponse;
            }
            this.persistence.persist(entityContext.getEntity(), false);
            return entityContext.okForEntityUpdate();
        }
    }

    public static interface IncrementSchedulingVersionFunction<TRestEntity> {
        public boolean apply(TRestEntity var1);
    }

    public static interface TransformEntityFunction<TEntityInterface extends IIdentifiable, TRestEntity extends TEntityInterface> {
        public TRestEntity transform(TEntityInterface var1, boolean var2);
    }

    public static interface UpdateEntityFunction<TEntityInterface extends IIdentifiable, TRestEntity extends TEntityInterface> {
        public Response apply(TRestEntity var1, TEntityInterface var2, boolean var3);
    }
}

