/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.extensionlinks;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.common.IExtendable;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.extensionlinks.AddExtensionLinkRequest;
import com.radiantminds.roadmap.common.handlers.extensionlinks.InvalidLinkException;
import com.radiantminds.roadmap.common.handlers.extensionlinks.RemoveExtensionLinkRequest;
import com.radiantminds.roadmap.common.handlers.extensionlinks.SecureExtensionLinkHandler;
import com.radiantminds.roadmap.common.handlers.extensionlinks.SetExtensionLinksRequest;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.extensions.RestExtensionLinkRequest;
import com.radiantminds.roadmap.common.rest.entities.workitems.links.RestExtensionLinksRequest;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.math3.util.Pair;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
public abstract class BaseExtendableExtensionLinkRestService<TEntity extends IExtendable> {
    private static final Log LOGGER = Log.with(BaseExtendableExtensionLinkRestService.class);
    private final SecureExtensionLinkHandler<TEntity> securedService;

    protected BaseExtendableExtensionLinkRestService(SecureExtensionLinkHandler<TEntity> securedService) {
        this.securedService = securedService;
    }

    @POST
    public Response addExtensionLink(@PathParam(value="id") String id, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="version") Long version, @QueryParam(value="clientId") String clientId, RestExtensionLinkRequest linkRequest) throws Exception {
        try {
            AddExtensionLinkRequest request = AddExtensionLinkRequest.Impl.create(linkRequest.getKey(), linkRequest.getLink(), linkRequest.getProgressConfiguration());
            return this.securedService.addExtensionLink(EntityContext.from(id, version, expectedPlanVersion, clientId), request);
        }
        catch (InvalidLinkException e) {
            LOGGER.info("illegal link encountered", new Object[0]);
            LOGGER.exception(e, Log.LogLevel.INFO);
            return ResponseBuilder.badRequest(RestMessaging.error("invalid-jira-link"));
        }
    }

    @PUT
    public Response setExtensionLinks(@PathParam(value="id") String id, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="version") Long version, @QueryParam(value="clientId") String clientId, RestExtensionLinksRequest links) throws Exception {
        Preconditions.checkNotNull((Object)links, (Object)"request must not be null");
        ArrayList requestLinks = Lists.newArrayList();
        for (RestExtensionLinkRequest restRequest : links.getLinks()) {
            requestLinks.add(new Pair<String, String>(restRequest.getKey(), restRequest.getLink()));
        }
        try {
            SetExtensionLinksRequest request = SetExtensionLinksRequest.Impl.create(requestLinks, links.getProgressConfiguration());
            return this.securedService.setExtensionLinks(EntityContext.from(id, version, expectedPlanVersion, clientId), request);
        }
        catch (InvalidLinkException e) {
            LOGGER.info("illegal link encountered", new Object[0]);
            LOGGER.exception(e, Log.LogLevel.INFO);
            return ResponseBuilder.badRequest(RestMessaging.error("invalid-jira-link"));
        }
    }

    @DELETE
    public Response removeExtensionLink(@PathParam(value="id") String id, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="version") Long version, @QueryParam(value="key") String key, @QueryParam(value="value") String value, @QueryParam(value="clientId") String clientId) throws Exception {
        try {
            RemoveExtensionLinkRequest request = RemoveExtensionLinkRequest.Impl.create(key, value);
            return this.securedService.removeExtensionLink(EntityContext.from(id, version, expectedPlanVersion, clientId), request);
        }
        catch (InvalidLinkException e) {
            LOGGER.info("illegal link encountered", new Object[0]);
            LOGGER.exception(e, Log.LogLevel.INFO);
            return ResponseBuilder.badRequest(RestMessaging.error("invalid-jira-link"));
        }
    }
}

