/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.maintenance;

import com.radiantminds.roadmap.common.data.integrity.DatabaseIntegrityUtil;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.services.maintenance.MaintenanceServiceHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/maintenance")
@Component
public class MaintenanceService {
    private final MaintenanceServiceHandler handler;

    @Autowired
    public MaintenanceService(SecuredInvocationHandlerFactory handlerFactory, PortfolioPlanPersistence planPersistence, DatabaseIntegrityUtil dbIntegrityUtil) {
        this.handler = handlerFactory.createProxy(MaintenanceServiceHandler.class, new MaintenanceServiceHandler.Impl(dbIntegrityUtil), planPersistence);
    }

    @POST
    @Path(value="dbintegrity")
    public Response listProjects(@QueryParam(value="plan") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId) throws Exception {
        return this.handler.fixDatabaseIntegrity(EntityContext.from(planId, expectedPlanVersion, clientId));
    }
}

