/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.maintenance;

import com.atlassian.pocketknife.api.logging.Log;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.integrity.DatabaseIntegrityUtil;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPluginAdminAccess;
import javax.ws.rs.core.Response;

public interface MaintenanceServiceHandler {
    @AuthorizedPluginAdminAccess
    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On, incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response fixDatabaseIntegrity(EntityContext<IPlan> var1) throws Exception;

    public static class Impl
    implements MaintenanceServiceHandler {
        private static final Log LOGGER = Log.with(Impl.class);
        private final DatabaseIntegrityUtil dbIntegrityUtil;

        public Impl(DatabaseIntegrityUtil dbIntegrityUtil) {
            this.dbIntegrityUtil = dbIntegrityUtil;
        }

        @Override
        public Response fixDatabaseIntegrity(EntityContext<IPlan> entityContext) throws Exception {
            try {
                this.dbIntegrityUtil.assertIntegrity(entityContext.getEntityId());
                return entityContext.ok();
            }
            catch (Exception ex) {
                LOGGER.error("Failure during DB integrity check or fixes.", new Object[0]);
                LOGGER.exception(ex, Log.LogLevel.ERROR);
                throw ex;
            }
        }
    }
}

