/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.permissions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.permissions.IPermission;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPermissionPersistence;
import com.radiantminds.roadmap.common.extensions.users.UserData;
import com.radiantminds.roadmap.common.extensions.users.UserExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.permissions.PlanPermissions;
import com.radiantminds.roadmap.common.permissions.PluginPermissions;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.common.ToRest;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.permissions.RestPermission;
import com.radiantminds.roadmap.common.rest.entities.permissions.RestPermissionModificationResult;
import com.radiantminds.roadmap.common.rest.services.permissions.PermissionEnrichments;
import com.radiantminds.roadmap.common.rest.services.permissions.SelfDeletionChecker;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;

public interface PlanPermissionServiceHandler {
    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.Off, incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response setPermission(EntityContext<IPlan> var1, RestPermission var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.Off, incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response deletePermission(EntityContext<IPlan> var1, String var2) throws Exception;

    @AuthorizedPlanReadAccess
    public Response getPermissions(EntityContext<IPlan> var1) throws Exception;

    public static class Impl
    implements PlanPermissionServiceHandler {
        private final PlanPermissions planPermissionHandler;
        private final UserExtension userExtension;
        private final PortfolioPermissionPersistence permissionPersistence;
        private final SelfDeletionChecker selfDeletionChecker;

        protected Impl(PortfolioPermissionPersistence permissionPersistence, PlanPermissions planPermissionHandler, PluginPermissions pluginPermissions, UserExtension userExtension) {
            this.permissionPersistence = permissionPersistence;
            this.planPermissionHandler = planPermissionHandler;
            this.userExtension = userExtension;
            this.selfDeletionChecker = new SelfDeletionChecker(planPermissionHandler, pluginPermissions, this.userExtension);
        }

        @Override
        public Response setPermission(EntityContext<IPlan> entityContext, RestPermission permission) throws Exception {
            String planId = entityContext.getEntityId();
            permission.setTargetType("plan");
            ArrayList unrequestedAddedPermissions = Lists.newArrayList();
            UserData activeUserData = this.userExtension.getActiveUserData();
            if (this.userExtension != null && IPermission.PERMISSION_EDITOR.equals(permission.getPermission()) && this.selfDeletionChecker.wouldAddLeadToDenied(planId, permission)) {
                RestPermission additionalPermission = RestPermission.createPlanEditorUserPermission(planId, activeUserData.getUserID());
                IPermission persistedPermission = this.permissionPersistence.persistCached(additionalPermission);
                additionalPermission.setDisplayName(this.userExtension.getDisplayName(activeUserData.getUserID()));
                additionalPermission.setId(persistedPermission.getId());
                unrequestedAddedPermissions.add(additionalPermission);
            }
            if ("group".equals(permission.getHolderType()) && this.userExtension.doesGroupSysadminRestrictionApply(activeUserData, permission.getHolderId())) {
                return ResponseBuilder.badRequest(RestMessaging.error("permission to denied to set this user group."));
            }
            IPermission stored = this.permissionPersistence.persist(permission);
            ModificationResult result = new ModificationResult(stored);
            if (unrequestedAddedPermissions.size() > 0) {
                result.setData(new RestPermissionModificationResult(unrequestedAddedPermissions));
            }
            return entityContext.ok(result);
        }

        @Override
        public Response deletePermission(EntityContext<IPlan> entityContext, String permissionId) throws Exception {
            String planId = entityContext.getEntityId();
            if (this.selfDeletionChecker.wouldRemovalLeadToDenied(planId, permissionId)) {
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            boolean success = this.permissionPersistence.delete(permissionId, false);
            if (success) {
                return entityContext.ok();
            }
            return ResponseBuilder.badRequest();
        }

        @Override
        public Response getPermissions(EntityContext<IPlan> entityContext) throws Exception {
            String planId = entityContext.getEntityId();
            List<IPermission> permissions = this.planPermissionHandler.getSecuredPermissions(this.userExtension, planId);
            List<RestPermission> retVal = ToRest.transferList(RestPermission.class, IPermission.class, permissions);
            if (this.userExtension != null) {
                PermissionEnrichments.enrichPermissions(retVal, this.userExtension);
            }
            return entityContext.okForList(Iterables.toArray(retVal, RestPermission.class));
        }
    }
}

