/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.streams;

import com.google.common.collect.Iterables;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.releases.IRelease;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.releases.AORelease;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtils;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtilsCallback;
import com.radiantminds.roadmap.common.rest.common.ToRest;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.releases.RestRelease;
import java.util.List;
import javax.ws.rs.core.Response;

public interface StreamServiceHandler {
    @AuthorizedPlanReadAccess
    public Response getLaterRelease(EntityContext<IStream> var1) throws Exception;

    @AuthorizedPlanReadAccess
    public Response getAllReleases(EntityContext<IStream> var1) throws Exception;

    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response entryDelete(EntityContext<IStream> var1, String var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response rankRelease(EntityContext<IStream> var1, RestRank var2) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response addReleaseToStream(EntityContext<IStream> var1, RestRelease var2) throws Exception;

    public static class Impl
    implements StreamServiceHandler {
        private final PortfolioReleasePersistence releasePersistence;
        private final PortfolioStreamPersistence streamPersistence;
        private final PortfolioWorkItemPersistence workItemPersistence;
        private final SubCollectionUtils subCollectionUtils;

        public Impl(ActiveObjectsUtilities activeObjectsUtilities, PortfolioReleasePersistence releasePersistence, PortfolioStreamPersistence streamPersistence, PortfolioWorkItemPersistence workItemPersistence) {
            this.releasePersistence = releasePersistence;
            this.streamPersistence = streamPersistence;
            this.workItemPersistence = workItemPersistence;
            this.subCollectionUtils = new SubCollectionUtils(activeObjectsUtilities, workItemPersistence);
        }

        @Override
        public Response getLaterRelease(EntityContext<IStream> entityContext) throws Exception {
            IRelease later = this.releasePersistence.getLaterReleaseCustom(entityContext.getEntityId());
            RestRelease laterRest = later != null ? ToRest.transferEntity(RestRelease.class, IRelease.class, later) : null;
            return entityContext.ok(laterRest);
        }

        @Override
        public Response getAllReleases(EntityContext<IStream> entityContext) throws Exception {
            List<IRelease> releases = this.releasePersistence.listCustom(entityContext.getEntityId(), false);
            return entityContext.okForList(Iterables.toArray(ToRest.transferList(RestRelease.class, IRelease.class, releases), RestRelease.class));
        }

        @Override
        public Response entryDelete(EntityContext<IStream> entityContext, String alternateStreamId) throws Exception {
            if (alternateStreamId == null) {
                return ResponseBuilder.badRequest(RestMessaging.error("no alternate stream id supplied"));
            }
            EntityInfo streamPlanInfo = this.streamPersistence.getEntityInfo(alternateStreamId);
            if (streamPlanInfo == null) {
                return ResponseBuilder.badRequest(RestMessaging.error("invalid-stream-assignment"));
            }
            this.workItemPersistence.moveWorkItemsToStream(entityContext.getEntityId(), alternateStreamId);
            this.streamPersistence.delete(entityContext.getEntityId(), false);
            return entityContext.ok();
        }

        @Override
        public Response rankRelease(EntityContext<IStream> entityContext, RestRank rank) throws Exception {
            return this.subCollectionUtils.rankEntity(entityContext, AORelease.class, this.releasePersistence, "stream", rank);
        }

        @Override
        public Response addReleaseToStream(EntityContext<IStream> entityContext, RestRelease newRelease) throws Exception {
            return this.subCollectionUtils.handleAddEntityToCollection(entityContext, AORelease.class, "stream", newRelease, new SubCollectionUtilsCallback.Adapter<IStream, IRelease, RestRelease>(){

                @Override
                public void setParent(IStream parent, IRelease entity) {
                    entity.setStream(parent);
                }

                @Override
                public IRelease persist(IRelease entity) throws Exception {
                    return releasePersistence.persist(entity);
                }

                @Override
                public IRelease get(String id) throws Exception {
                    return (IRelease)releasePersistence.get(id);
                }

                @Override
                public ModificationResult buildModificationResult(IRelease stored) throws Exception {
                    return new ModificationResult(stored);
                }
            });
        }
    }
}

