/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.streams.teams;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.rest.services.streams.teams.StreamTeamAssignmentRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TeamsAvailableValidator {
    private static final Log LOGGER = Log.with(TeamsAvailableValidator.class);
    private static final String UNAVAILABLE_TEAM_ID_ERROR = "team-not-available";
    private final PortfolioTeamPersistence teamPersistence;

    public TeamsAvailableValidator(PortfolioTeamPersistence teamPersistence) {
        this.teamPersistence = teamPersistence;
    }

    public Optional<String> tryGetErrorResponse(StreamTeamAssignmentRequest request) throws Exception {
        return this.tryGetErrorResponse(request.getTeamIds());
    }

    public Optional<String> tryGetErrorResponse(Set<String> teamIds) throws Exception {
        ArrayList idsList;
        List<String> idsSubSet;
        if (!teamIds.isEmpty() && !(idsSubSet = this.teamPersistence.existingSubset(idsList = Lists.newArrayList(teamIds))).containsAll(teamIds)) {
            LOGGER.debug("teams missing", new Object[0]);
            return Optional.of((Object)UNAVAILABLE_TEAM_ID_ERROR);
        }
        return Optional.absent();
    }
}

