/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.system.projects;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.extensions.projects.ListProjectResult;
import com.radiantminds.roadmap.common.rest.services.system.projects.RestIssueType;
import com.radiantminds.roadmap.common.rest.services.system.projects.RestProject;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="result")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestProjectSearchResult {
    @XmlElement
    private List<RestProject> projects;
    @XmlElement
    private Boolean moreAvailable;
    @XmlElement
    private List<RestIssueType> issueTypes;
    @XmlElement
    private Boolean timeTrackingEnabled;
    @XmlElement
    private String epicIssueType;
    @XmlElement
    private String epicLinkField;
    @XmlElement
    private String epicLabelField;
    @XmlElement
    private String storyPointsField;
    @XmlElement
    private Boolean jiraAgileCustomFieldsUnavailable;

    @Deprecated
    private RestProjectSearchResult() {
    }

    private RestProjectSearchResult(List<RestProject> projects, Boolean moreAvailable, List<RestIssueType> issueTypes, Boolean timeTrackingEnabled, String epicIssueType, String epicLinkField, String epicLabelField, String storyPointsField, Boolean jiraAgileCustomFieldsUnavailable) {
        this.projects = projects;
        this.moreAvailable = moreAvailable;
        this.issueTypes = issueTypes;
        this.timeTrackingEnabled = timeTrackingEnabled;
        this.epicIssueType = epicIssueType;
        this.epicLinkField = epicLinkField;
        this.epicLabelField = epicLabelField;
        this.storyPointsField = storyPointsField;
        this.jiraAgileCustomFieldsUnavailable = jiraAgileCustomFieldsUnavailable;
    }

    public static RestProjectSearchResult from(ListProjectResult listProjectResult) {
        return new RestProjectSearchResult(Lists.newArrayList((Iterable)Iterables.transform(listProjectResult.getProjects(), RestProject.TRANSFORMATION)), listProjectResult.isMoreAvailable() ? Boolean.TRUE : null, Lists.newArrayList((Iterable)Iterables.transform(listProjectResult.getIssueTypes(), RestIssueType.TRANSFORMATION)), listProjectResult.isTimeTrackingEnabled(), listProjectResult.getEpicIssueType(), listProjectResult.getEpicLinkField(), listProjectResult.getEpicLabelField(), listProjectResult.getStoryPointsField(), listProjectResult.isJiraAgileCustomFieldsUnavailable() ? Boolean.TRUE : null);
    }
}

