/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.themes;

import com.radiantminds.roadmap.common.data.entities.themes.ITheme;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioThemePersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.common.RestPercentage;
import com.radiantminds.roadmap.common.rest.entities.themes.RestTheme;
import com.radiantminds.roadmap.common.rest.services.common.BaseOperationsService;
import com.radiantminds.roadmap.common.rest.services.themes.ThemeServiceHandler;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/themes")
@Component
public class ThemeService
extends BaseOperationsService<ITheme, RestTheme> {
    private final ThemeServiceHandler handler;

    @Autowired
    public ThemeService(SecuredInvocationHandlerFactory handlerFactory, PortfolioPlanPersistence planPersistence, PortfolioThemePersistence themePersistence) {
        super(RestTheme.class, themePersistence, handlerFactory);
        this.handler = handlerFactory.createProxy(ThemeServiceHandler.class, new ThemeServiceHandler.Impl(themePersistence, planPersistence), themePersistence);
    }

    @Override
    protected RestTheme transform(ITheme entity, boolean includeReplanningData) {
        return new RestTheme(entity);
    }

    @Override
    protected Response update(RestTheme source, ITheme target, boolean allowNull) {
        this.updateCommons(source, target, allowNull);
        if (allowNull || source.getColor() != null) {
            target.setColor(source.getColor());
        }
        return null;
    }

    @Override
    @DELETE
    @Path(value="/{id}")
    public Response entryDelete(@PathParam(value="id") String id, @QueryParam(value="version") Long version, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId) throws Exception {
        return this.handler.entryDelete(EntityContext.from(id, version, expectedPlanVersion, clientId));
    }

    @PUT
    @Path(value="{id}/percentage")
    public Response setPercentage(@PathParam(value="id") String id, RestPercentage value, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId) throws Exception {
        return this.handler.setPercentage(EntityContext.from(id, expectedPlanVersion, clientId), value.getValue());
    }
}

