/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.common.sql.MoveMode;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.extensions.issues.IssueSyncData;
import com.radiantminds.roadmap.common.extensions.issues.PortfolioToJiraSyncExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkItem;
import com.radiantminds.roadmap.common.rest.entities.workitems.bulk.RestWorkItemBulk;
import com.radiantminds.roadmap.common.rest.entities.workitems.bulk.RestWorkItemBulkStatus;
import com.radiantminds.roadmap.common.rest.services.workitems.WorkItemUtils;
import com.radiantminds.roadmap.common.rest.services.workitems.constraints.WorkItemConstraintChecker;
import com.radiantminds.roadmap.common.rest.utils.async.LongRunningServiceTask;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;

public class WorkItemBulkAddTask
extends LongRunningServiceTask {
    private final PortfolioWorkItemPersistence workItemPersistence;
    private final WorkItemUtils workItemPersister;
    private final WorkItemConstraintChecker workItemConstraintChecker;
    private final IPlan plan;
    private final RestWorkItemBulk bulk;
    private final EntityContext<IPlan> entityContext;
    private final PortfolioToJiraSyncExtension portfolioToJiraSyncExtension;
    private int done;

    public WorkItemBulkAddTask(RestWorkItemBulk workItemBulk, EntityContext<IPlan> entityContext, WorkItemUtils workItemPersister, PortfolioWorkItemPersistence workItemPersistence, PortfolioToJiraSyncExtension portfolioToJiraSyncExtension) {
        this.plan = entityContext.getEntity();
        this.entityContext = entityContext;
        this.bulk = workItemBulk;
        this.workItemPersistence = workItemPersistence;
        this.workItemPersister = workItemPersister;
        this.workItemConstraintChecker = new WorkItemConstraintChecker(workItemPersistence);
        this.portfolioToJiraSyncExtension = portfolioToJiraSyncExtension;
    }

    private void progress() {
        this.setState("done", ++this.done);
    }

    @Override
    public Response execute() throws Exception {
        int total = WorkItemBulkAddTask.countRecursive(this.bulk.getItems());
        this.setState("total", total);
        this.setState("done", 0);
        this.done = 0;
        Map<String, String> parentThemeInheritanceMap = this.getParentThemeInheritance();
        Set<String> unstructedParentIds = this.addWorkItemsRecursive(this.bulk.getItems(), null, new IAddCallback(){

            @Override
            public void done() {
                WorkItemBulkAddTask.this.progress();
            }
        });
        for (Map.Entry<String, String> entry : parentThemeInheritanceMap.entrySet()) {
            IWorkItem item = (IWorkItem)this.workItemPersistence.get(entry.getKey());
            this.workItemPersistence.tryInheritTheme(entry.getValue(), item);
        }
        this.portfolioToJiraSyncExtension.syncWorkItemsToIssues(IssueSyncData.createEstimateSyncFor(unstructedParentIds));
        return this.entityContext.ok();
    }

    private Map<String, String> getParentThemeInheritance() throws PersistenceException {
        HashMap parentThemeInheritanceMap = Maps.newHashMap();
        for (RestWorkItem restWorkItem : this.bulk.getItems()) {
            String theme;
            IWorkItem item;
            if (restWorkItem.getId() == null || (item = (IWorkItem)this.workItemPersistence.get(restWorkItem.getId())) == null || (theme = (String)item.getThemeId().orNull()) == null) continue;
            parentThemeInheritanceMap.put(item.getId(), theme);
        }
        return parentThemeInheritanceMap;
    }

    @Override
    public Object getStatusEntity() {
        return new RestWorkItemBulkStatus((Integer)this.getState("done"), (Integer)this.getState("total"));
    }

    private static int countRecursive(List<RestWorkItem> items) {
        if (items == null) {
            return 0;
        }
        int c = items.size();
        for (RestWorkItem item : items) {
            c += WorkItemBulkAddTask.countRecursive(item.getRestChildren());
        }
        return c;
    }

    private Set<String> addWorkItemsRecursive(List<RestWorkItem> items, IWorkItem parent, IAddCallback callback) throws Exception {
        if (items == null) {
            return Sets.newHashSet();
        }
        HashSet unstructedParentIds = Sets.newHashSet();
        int newItemParentChildCountOnStart = parent != null && parent.getChildren() != null ? parent.getChildren().size() : 0;
        for (RestWorkItem item : items) {
            IWorkItem persistedItem = null;
            if (item.getId() != null) {
                persistedItem = (IWorkItem)this.workItemPersistence.get(item.getId());
            }
            if (persistedItem == null) {
                item.setId(null);
                item.setPlan(this.plan);
                item.setParent(parent);
                this.workItemConstraintChecker.checkAddAllowed(item);
                persistedItem = this.workItemPersistence.persist(item);
                String insertAfter = !WorkItems.Types.INITIATIVE.equals(item.getType()) ? (parent != null && !WorkItems.Types.INITIATIVE.equals(parent.getType()) ? this.workItemPersistence.getIdWithHighestSortOrderInEpic(parent.getId()) : this.workItemPersistence.getIdWithHighestSortOrder(this.plan.getId(), "plan")) : this.workItemPersistence.getIdWithHighestSortOrder(this.plan.getId(), "plan-initiatives");
                this.workItemPersistence.move(persistedItem.getId(), insertAfter, MoveMode.AFTER);
                this.workItemPersister.onAfterPostPersisting(item, persistedItem);
            }
            if (newItemParentChildCountOnStart == 0 && parent != null) {
                this.workItemPersistence.reactToCreationOfFirstChild(parent.getId());
                newItemParentChildCountOnStart = 1;
                unstructedParentIds.add(parent.getId());
            }
            callback.done();
            unstructedParentIds.addAll(this.addWorkItemsRecursive(item.getRestChildren(), persistedItem, callback));
        }
        return unstructedParentIds;
    }

    public static LongRunningServiceTask create(EntityContext<IPlan> entityContext, RestWorkItemBulk bulk, WorkItemUtils workItemPersister, PortfolioWorkItemPersistence workItemPersistence, PortfolioToJiraSyncExtension portfolioToJiraSyncExtension) {
        return new WorkItemBulkAddTask(bulk, entityContext, workItemPersister, workItemPersistence, portfolioToJiraSyncExtension);
    }

    private static interface IAddCallback {
        public void done();
    }
}

