/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.dependencies;

import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.services.workitems.dependencies.WorkItemDependencyServiceHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/workitems/{id}/dependencies")
@Component
public class WorkItemDependencyService {
    private final WorkItemDependencyServiceHandler handler;

    @Autowired
    public WorkItemDependencyService(SecuredInvocationHandlerFactory handlerFactory, PortfolioWorkItemPersistence workItemPersistence) {
        this.handler = handlerFactory.createProxy(WorkItemDependencyServiceHandler.class, new WorkItemDependencyServiceHandler.Impl(workItemPersistence), workItemPersistence);
    }

    @DELETE
    public Response deleteDependency(@PathParam(value="id") String dependent, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="dependee") String dependee, @QueryParam(value="clientId") String clientId) throws Exception {
        return this.handler.deleteDependency(EntityContext.from(dependent, expectedPlanVersion, clientId), dependee);
    }

    @GET
    public Response getDependenciesForWorkItem(@QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="includeDone") Boolean includeDone, @PathParam(value="id") String workItemId) throws Exception {
        return this.handler.getDependenciesForWorkItem(EntityContext.from(workItemId, expectedPlanVersion), includeDone);
    }
}

