/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.streamrelease;

import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.assignment.RestReleaseStreamAssignment;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.services.common.Operation;
import com.radiantminds.roadmap.common.rest.services.workitems.constraints.WorkItemConstraintChecker;
import javax.ws.rs.core.Response;

public class StreamReleaseOperation
extends Operation {
    private final PortfolioWorkItemPersistence workItemPersistence;
    private final PortfolioStreamPersistence streamPersistence;
    private final RestReleaseStreamAssignment assignment;
    private final DataMode dataMode;
    private final WorkItemConstraintChecker workItemConstraintChecker;

    public StreamReleaseOperation(PortfolioWorkItemPersistence workItemPersistence, PortfolioStreamPersistence streamPersistence, RestReleaseStreamAssignment assignment, DataMode dataMode) {
        this.workItemPersistence = workItemPersistence;
        this.streamPersistence = streamPersistence;
        this.assignment = assignment;
        this.dataMode = dataMode;
        this.workItemConstraintChecker = new WorkItemConstraintChecker(workItemPersistence);
    }

    @Override
    public Response preOperationChecks() throws Exception {
        boolean valid;
        if (this.assignment == null) {
            return ResponseBuilder.badRequest(RestMessaging.error("no assignment supplied"));
        }
        if (this.assignment.getStreamId() == null) {
            return ResponseBuilder.badRequest(RestMessaging.error("invalid-stream-assignment"));
        }
        if (!this.streamPersistence.exists(this.assignment.getStreamId())) {
            return ResponseBuilder.badRequest(RestMessaging.error("invalid-stream-assignment"));
        }
        if (this.assignment.getReleaseId() != null && !(valid = this.workItemPersistence.validateStreamReleaseAssignment(this.assignment.getStreamId(), this.assignment.getReleaseId()))) {
            return ResponseBuilder.badRequest(RestMessaging.error("invalid-stream-assignment"));
        }
        return null;
    }

    @Override
    public void preItemCheck(String workItemId) throws Exception {
        String constraintCheck = this.workItemConstraintChecker.isAssignable(workItemId);
        if (constraintCheck != null) {
            throw new Exception("type-not-assignable");
        }
    }

    @Override
    public void performOperation(String workItemId) throws Exception {
        this.workItemPersistence.setStreamReleaseAssignment(workItemId, this.assignment.getStreamId(), this.assignment.getReleaseId(), this.dataMode == DataMode.Replanning);
    }
}

