/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.streamrelease;

import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.BulkEntityContext;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.entities.assignment.RestReleaseStreamAssignment;
import com.radiantminds.roadmap.common.rest.services.common.OperationExecutor;
import com.radiantminds.roadmap.common.rest.services.workitems.streamrelease.StreamReleaseOperationFactory;
import javax.ws.rs.core.Response;

public interface WorkItemStreamReleaseServiceHandler {
    @AuthorizedPlanUserAccess
    public Response setAssignment(EntityContext<IWorkItem> var1, RestReleaseStreamAssignment var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response setReplanningAssignment(EntityContext<IWorkItem> var1, RestReleaseStreamAssignment var2) throws Exception;

    @AuthorizedPlanUserAccess
    public Response setAssignmentInBulk(BulkEntityContext<IWorkItem> var1, RestReleaseStreamAssignment var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response setReplanningAssignmentInBulk(BulkEntityContext<IWorkItem> var1, RestReleaseStreamAssignment var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response resetReplanningRelease(EntityContext<IWorkItem> var1) throws Exception;

    public static class Impl
    implements WorkItemStreamReleaseServiceHandler {
        private final OperationExecutor operationExecutor;
        private final PortfolioWorkItemPersistence workItemPersistence;
        private final StreamReleaseOperationFactory operationFactory;

        public Impl(OperationExecutor operationExecutor, PortfolioWorkItemPersistence workItemPersistence, PortfolioStreamPersistence streamPersistence) {
            this.operationExecutor = operationExecutor;
            this.workItemPersistence = workItemPersistence;
            this.operationFactory = new StreamReleaseOperationFactory(workItemPersistence, streamPersistence);
        }

        @Override
        public Response setAssignment(EntityContext<IWorkItem> entityContext, RestReleaseStreamAssignment assignment) throws Exception {
            return this.operationExecutor.execute(entityContext, this.operationFactory.create(DataMode.Default, assignment));
        }

        @Override
        public Response setReplanningAssignment(EntityContext<IWorkItem> entityContext, RestReleaseStreamAssignment assignment) throws Exception {
            return this.operationExecutor.execute(entityContext, this.operationFactory.create(DataMode.Replanning, assignment));
        }

        @Override
        public Response setAssignmentInBulk(BulkEntityContext<IWorkItem> entityContext, RestReleaseStreamAssignment assignment) throws Exception {
            return this.operationExecutor.executeInBulk(entityContext, this.operationFactory.create(DataMode.Default, assignment));
        }

        @Override
        public Response setReplanningAssignmentInBulk(BulkEntityContext<IWorkItem> entityContext, RestReleaseStreamAssignment assignment) throws Exception {
            return this.operationExecutor.executeInBulk(entityContext, this.operationFactory.create(DataMode.Replanning, assignment));
        }

        @Override
        public Response resetReplanningRelease(EntityContext<IWorkItem> entityContext) throws Exception {
            this.workItemPersistence.deleteReplanningRelease(entityContext.getEntityId());
            this.workItemPersistence.deleteReplanningStream(entityContext.getEntityId());
            return entityContext.okForEntityUpdate();
        }
    }
}

