/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.teamresource;

import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.BulkEntityContext;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.entities.assignment.RestTeamResourceAssignment;
import com.radiantminds.roadmap.common.rest.services.common.OperationExecutor;
import com.radiantminds.roadmap.common.rest.services.workitems.teamresource.AssignmentType;
import com.radiantminds.roadmap.common.rest.services.workitems.teamresource.TeamResourceOperationFactory;
import javax.ws.rs.core.Response;

public interface WorkItemTeamResourceServiceHandler {
    @AuthorizedPlanUserAccess
    public Response setAssignment(EntityContext<IWorkItem> var1, RestTeamResourceAssignment var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response setReplanningAssignment(EntityContext<IWorkItem> var1, RestTeamResourceAssignment var2) throws Exception;

    @AuthorizedPlanUserAccess
    public Response setAssignmentInBulk(BulkEntityContext<IWorkItem> var1, RestTeamResourceAssignment var2) throws Exception;

    @AuthorizedPlanUserAccess
    public Response setSprintAssignmentInBulk(BulkEntityContext<IWorkItem> var1, RestTeamResourceAssignment var2) throws Exception;

    @AuthorizedPlanUserAccess
    public Response setResourceAssignmentsInBulk(BulkEntityContext<IWorkItem> var1, RestTeamResourceAssignment var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response setReplanningAssignmentInBulk(BulkEntityContext<IWorkItem> var1, RestTeamResourceAssignment var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response setReplanningResourceAssignmentsInBulk(BulkEntityContext<IWorkItem> var1, RestTeamResourceAssignment var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response resetReplanningTeam(EntityContext<IWorkItem> var1) throws Exception;

    public static class Impl
    implements WorkItemTeamResourceServiceHandler {
        private final OperationExecutor operationExecutor;
        private final PortfolioWorkItemPersistence workItemPersistence;
        private final TeamResourceOperationFactory operationFactory;

        public Impl(OperationExecutor operationExecutor, PortfolioWorkItemPersistence workItemPersistence, PortfolioTeamPersistence teamPersistence) {
            this.operationExecutor = operationExecutor;
            this.workItemPersistence = workItemPersistence;
            this.operationFactory = new TeamResourceOperationFactory(workItemPersistence, teamPersistence);
        }

        @Override
        public Response setAssignment(EntityContext<IWorkItem> entityContext, RestTeamResourceAssignment assignment) throws Exception {
            return this.operationExecutor.execute(entityContext, this.operationFactory.create(DataMode.Default, assignment));
        }

        @Override
        public Response setReplanningAssignment(EntityContext<IWorkItem> entityContext, RestTeamResourceAssignment assignment) throws Exception {
            return this.operationExecutor.execute(entityContext, this.operationFactory.create(DataMode.Replanning, assignment));
        }

        @Override
        public Response setAssignmentInBulk(BulkEntityContext<IWorkItem> entityContext, RestTeamResourceAssignment assignment) throws Exception {
            return this.operationExecutor.executeInBulk(entityContext, this.operationFactory.create(DataMode.Default, assignment, AssignmentType.ASSIGN_EVERYTHING));
        }

        @Override
        public Response setSprintAssignmentInBulk(BulkEntityContext<IWorkItem> entityContext, RestTeamResourceAssignment assignment) throws Exception {
            return this.operationExecutor.executeInBulk(entityContext, this.operationFactory.create(DataMode.Default, assignment, AssignmentType.ASSIGN_SPRINT));
        }

        @Override
        public Response setResourceAssignmentsInBulk(BulkEntityContext<IWorkItem> entityContext, RestTeamResourceAssignment assignment) throws Exception {
            return this.operationExecutor.executeInBulk(entityContext, this.operationFactory.create(DataMode.Default, assignment, AssignmentType.ASSIGN_RESOURCES));
        }

        @Override
        public Response setReplanningAssignmentInBulk(BulkEntityContext<IWorkItem> entityContext, RestTeamResourceAssignment assignment) throws Exception {
            return this.operationExecutor.executeInBulk(entityContext, this.operationFactory.create(DataMode.Replanning, assignment, AssignmentType.ASSIGN_EVERYTHING));
        }

        @Override
        public Response setReplanningResourceAssignmentsInBulk(BulkEntityContext<IWorkItem> entityContext, RestTeamResourceAssignment assignment) throws Exception {
            return this.operationExecutor.executeInBulk(entityContext, this.operationFactory.create(DataMode.Replanning, assignment, AssignmentType.ASSIGN_RESOURCES));
        }

        @Override
        public Response resetReplanningTeam(EntityContext<IWorkItem> entityContext) throws Exception {
            this.workItemPersistence.deleteReplanningTeam(entityContext.getEntityId());
            return entityContext.okForEntityUpdate();
        }
    }
}

