/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.common;

import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingConfig;
import com.radiantminds.roadmap.common.scheduling.common.HoursTimeAmountTransformer;
import com.radiantminds.roadmap.common.scheduling.common.StoryPointAmountTransformer;
import com.radiantminds.roadmap.common.scheduling.common.TimeAmountTransformer;
import com.radiantminds.roadmap.common.scheduling.common.WorkDayTimeAmountTransformer;

abstract class TimeAmountTransformerFactory {
    TimeAmountTransformerFactory() {
    }

    static TimeAmountTransformer create(SchedulingConfig configuration) {
        if (configuration.getPlanningUnit().equals(PlanningUnit.HOURS.toString())) {
            return new HoursTimeAmountTransformer();
        }
        if (configuration.getPlanningUnit().equals(PlanningUnit.DAYS.toString())) {
            return new WorkDayTimeAmountTransformer(configuration.getHoursPerDay());
        }
        if (configuration.getPlanningUnit().equals(PlanningUnit.STORY_POINTS.toString())) {
            return new StoryPointAmountTransformer();
        }
        throw new IllegalArgumentException("invalid planning unit");
    }
}

