/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.entities.transferables;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.skills.SchedulingSkill;
import com.radiantminds.roadmap.common.data.entities.skills.SchedulingStage;
import com.radiantminds.roadmap.common.scheduling.entities.transferables.TransferableSkill;
import java.util.List;

public class TransferableStage
implements SchedulingStage {
    private Double percentage;
    private List<TransferableSkill> skills;
    private String id;
    private Long sortOrder;
    @Deprecated
    private String title;
    @Deprecated
    private String color;

    TransferableStage(SchedulingStage stage) {
        this.id = stage.getId();
        this.sortOrder = stage.getSortOrder();
        this.percentage = stage.getPercentage();
        this.skills = Lists.newArrayList();
        for (SchedulingSkill schedulingSkill : stage.getSkills()) {
            this.skills.add(new TransferableSkill(schedulingSkill));
        }
        this.title = stage.getTitle();
        this.color = stage.getColor();
    }

    @Override
    public List<? extends SchedulingSkill> getSkills() {
        return this.skills;
    }

    @Override
    public Long getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public Double getPercentage() {
        return this.percentage;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getColor() {
        return this.color;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

