/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.stats;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IEpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisodeStream;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.ITimePlan;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.RmSchedulingUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.EpisodeStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IEpisodeStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IWorkSlotData;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.OverbookedWorkCalculator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EpisodeStatisticsProvider {
    private final OverbookedWorkCalculator overbookedWorkCalculator = new OverbookedWorkCalculator();

    public IEpisodeStatistics createReleaseStatistics(IEpisodeSchedule schedule, Set<IWorkSlotData> assignedWorkSlotStatistics, Map<IWorkSlot, IResourceGroup> slotToGroupMap, ITimePlan timePlan) {
        String id = schedule.getId();
        double avgResourceUtilization = this.calculateAvgResourceUtilization(schedule.getWorkAssignments(), slotToGroupMap, assignedWorkSlotStatistics);
        double episodeWorkLoad = RmSchedulingUtils.getWorkLoadSum(schedule.getWorkAssignments());
        double availableWork = this.calculateAvailableWork(assignedWorkSlotStatistics, (IEpisodeStream)timePlan.getStreamForEpisode(schedule.getEpisode().getId()).get());
        PositivePrimitivesMap<IResourceType> freeCapacitiesOfResourceTypes = this.calculateFreeCapacitiesForEpisode(schedule, slotToGroupMap, assignedWorkSlotStatistics);
        Double overbookedWorkPercentage = this.overbookedWorkCalculator.calculateOverbookedWork(schedule, episodeWorkLoad);
        return new EpisodeStatistics(id, avgResourceUtilization, episodeWorkLoad, availableWork, freeCapacitiesOfResourceTypes, overbookedWorkPercentage, RmUtils.getMergedIntervals(assignedWorkSlotStatistics));
    }

    private PositivePrimitivesMap<IResourceType> calculateFreeCapacitiesForEpisode(IEpisodeSchedule schedule, Map<IWorkSlot, IResourceGroup> slotToGroupMap, Set<IWorkSlotData> assignedWorkSlotStatistics) {
        MutablePositivePrimitivesMap<IWorkResource> freeWorkInEpisode = this.getSpecifiedWork(slotToGroupMap, assignedWorkSlotStatistics);
        PositivePrimitivesMap<IWorkResource> workLoadOfEpisode = this.getWorkLoad(schedule);
        freeWorkInEpisode.subtract(workLoadOfEpisode);
        MutablePositivePrimitivesMap<IResourceType> typeMap = RmCollectionUtils.newMutablePositiveMap();
        for (IWorkResource resource : freeWorkInEpisode.keySet()) {
            Set<IResourceType> types = resource.getResourceTypes();
            for (IResourceType type : types) {
                typeMap.add(type, freeWorkInEpisode.get(resource));
            }
        }
        return typeMap;
    }

    private PositivePrimitivesMap<IWorkResource> getWorkLoad(IEpisodeSchedule schedule) {
        MutablePositivePrimitivesMap<IWorkResource> loadMap = RmCollectionUtils.newMutablePositiveMap();
        Set<IWorkAssignment> workAssignments = schedule.getWorkAssignments();
        for (IWorkAssignment assignment : workAssignments) {
            IWorkResource resource = assignment.getResource();
            float workLoad = assignment.getAssignedWorkUnits();
            loadMap.add(resource, workLoad);
        }
        return loadMap;
    }

    private MutablePositivePrimitivesMap<IWorkResource> getSpecifiedWork(Map<IWorkSlot, IResourceGroup> slotToGroupMap, Set<IWorkSlotData> assignedWorkSlotStatistics) {
        MutablePositivePrimitivesMap<IWorkResource> workMap = RmCollectionUtils.newMutablePositiveMap();
        for (IWorkSlotData slotEntry : assignedWorkSlotStatistics) {
            IWorkSlot slot = slotEntry.getWorkSlot();
            IResourceGroup group = slotToGroupMap.get(slot);
            Set<IWorkResource> resources = group.getResources();
            for (IWorkResource resource : resources) {
                float workInWorkSlot = resource.getUnassignedWorkInWorkSlot(slot.getIndex());
                workMap.add(resource, workInWorkSlot);
            }
        }
        return workMap;
    }

    private double calculateAvgResourceUtilization(Set<IWorkAssignment> workAssignments, Map<IWorkSlot, IResourceGroup> slotToGroupMap, Set<IWorkSlotData> assignedWorkSlotStatistics) {
        Map<String, Double> assignedWork = this.createAssignedWorkMap(workAssignments);
        Map<String, Double> availableWork = this.createAvailableWork(slotToGroupMap, assignedWorkSlotStatistics);
        double percentageSum = 0.0;
        int count = 0;
        for (Map.Entry<String, Double> availableEntry : availableWork.entrySet()) {
            String resource = availableEntry.getKey();
            double available = availableEntry.getValue();
            if (available == 0.0) continue;
            Double assigned = assignedWork.get(resource);
            if (assigned != null) {
                percentageSum += assigned / available;
            }
            ++count;
        }
        if (count == 0) {
            return 1.0;
        }
        return percentageSum / (double)count;
    }

    private Map<String, Double> createAvailableWork(Map<IWorkSlot, IResourceGroup> slotToGroupMap, Set<IWorkSlotData> assignedWorkSlotStatistics) {
        HashMap availableMap = Maps.newHashMap();
        for (IWorkSlotData slotEntry : assignedWorkSlotStatistics) {
            IWorkSlot slot = slotEntry.getWorkSlot();
            IResourceGroup group = slotToGroupMap.get(slot);
            Set<IWorkResource> resources = group.getResources();
            for (IWorkResource resource : resources) {
                double availableWorkInWorkSlot = resource.getUnassignedWorkInWorkSlot(slot.getIndex());
                RmUtils.addDoublesKeywise(availableMap, resource.getId(), availableWorkInWorkSlot);
            }
        }
        return availableMap;
    }

    private Map<String, Double> createAssignedWorkMap(Set<IWorkAssignment> workAssignments) {
        HashMap availableWork = Maps.newHashMap();
        for (IWorkAssignment workAssignment : workAssignments) {
            IWorkResource resource = workAssignment.getResource();
            double amount = workAssignment.getAssignedWorkUnits();
            RmUtils.addDoublesKeywise(availableWork, resource.getId(), amount);
        }
        return availableWork;
    }

    private double calculateAvailableWork(Set<IWorkSlotData> workSlotStatistics, IEpisodeStream streamForEpisode) {
        Set<String> assignableGroupIds = streamForEpisode.getAssignableGroupIds();
        double sum = 0.0;
        for (IWorkSlotData stats : workSlotStatistics) {
            if (!assignableGroupIds.contains(stats.getGroupId())) continue;
            sum += stats.getAvailableWork();
        }
        return sum;
    }
}

