/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.stats;

import com.atlassian.rm.jpo.scheduling.roadmap.analysis.ISlotBottleneckAnalysis;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.SlotBottleneckAnalysis;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IEpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IRoadmapSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.ITimePlan;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.function.IntegerInterval;
import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.EpisodeStatisticsProvider;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IEpisodeStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IRoadmapStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IRoadmapStatisticsProvider;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IWorkSlotData;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.PartialSlotData;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.ScheduleStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.WorkSlotStatisticsProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ScheduleStatisticsProvider
implements IRoadmapStatisticsProvider {
    private final EpisodeStatisticsProvider episodeStatisticsProvider;
    private final ISlotBottleneckAnalysis bottleneckAnalysis = new SlotBottleneckAnalysis();
    private final WorkSlotStatisticsProvider slotStatisticsProvider = new WorkSlotStatisticsProvider();

    public ScheduleStatisticsProvider() {
        this.episodeStatisticsProvider = new EpisodeStatisticsProvider();
    }

    ScheduleStatisticsProvider(EpisodeStatisticsProvider episodeStatisticsProvider) {
        this.episodeStatisticsProvider = episodeStatisticsProvider;
    }

    @Override
    public IRoadmapStatistics calculateScheduleStatistics(IRoadmapSchedule schedule, IRoadmapProblem problem) {
        int endTime = schedule.getAnalysisEndTime();
        if (endTime < 0) {
            return ScheduleStatistics.EMPTY;
        }
        Map<IWorkSlot, IResourceGroup> slotToGroupMap = this.getSlotGroupMap(problem.getResourceGroups(), endTime);
        Map<IWorkSlot, Set<IEpisodeSchedule>> slotToEpisodeSchedule = ScheduleStatisticsProvider.createEpisodeToSlotStatsMap(schedule.getEpisodeSchedulesPrioOrdered(), slotToGroupMap.keySet());
        Map<IWorkSlot, PositivePrimitivesMap<IResourceType>> bottleneckWeight = this.bottleneckAnalysis.calculateSlotBottlenecks(problem, schedule).getSlotToBottleneckValues();
        Map<IWorkSlot, Set<IWorkAssignment>> slotToWorkAssignments = ScheduleStatisticsProvider.getWorkSlotMap(schedule.getWorkAssignments());
        BiMap<IWorkSlot, IWorkSlotData> slotStatisitics = this.slotStatisticsProvider.getWorkSlotStatistics(slotToWorkAssignments, slotToGroupMap, bottleneckWeight);
        slotStatisitics.putAll(this.getPartialSlotData(problem.getResourceGroups(), endTime));
        Set<IEpisodeStatistics> episodeStatistics = this.getReleaseStatistics(schedule.getEpisodeSchedulesPrioOrdered(), slotStatisitics, slotToEpisodeSchedule, slotToGroupMap, problem.getTimePlan());
        ScheduleStatistics roadmapStatistics = new ScheduleStatistics(slotStatisitics.values(), episodeStatistics);
        return roadmapStatistics;
    }

    private Map<? extends IWorkSlot, ? extends IWorkSlotData> getPartialSlotData(Set<IResourceGroup> resourceGroups, int endTime) {
        HashMap map = Maps.newHashMap();
        for (IResourceGroup group : resourceGroups) {
            IWorkSlot slot = group.getSlotOrNextForTimeStep(endTime);
            if (endTime == slot.getEnd() || endTime < slot.getStart()) continue;
            map.put(slot, new PartialSlotData(slot));
        }
        return map;
    }

    private Set<IEpisodeStatistics> getReleaseStatistics(LinkedHashSet<IEpisodeSchedule> episodeSchedules, BiMap<IWorkSlot, IWorkSlotData> slotStatisitics, Map<IWorkSlot, Set<IEpisodeSchedule>> slotAssignment, Map<IWorkSlot, IResourceGroup> slotToGroupMap, ITimePlan timePlan) {
        Map<IEpisodeSchedule, Set<IWorkSlotData>> releaseToSlotStatisticsMap = this.createEpisodeToSlotStatsMap(episodeSchedules, slotAssignment, slotStatisitics);
        HashSet episodeStatistics = Sets.newHashSet();
        for (Map.Entry<IEpisodeSchedule, Set<IWorkSlotData>> releaseSlotStats : releaseToSlotStatisticsMap.entrySet()) {
            IEpisodeStatistics episodeStatistic = this.episodeStatisticsProvider.createReleaseStatistics(releaseSlotStats.getKey(), releaseSlotStats.getValue(), slotToGroupMap, timePlan);
            episodeStatistics.add(episodeStatistic);
        }
        return episodeStatistics;
    }

    private Map<IEpisodeSchedule, Set<IWorkSlot>> createEpisodeToSlotsMap(LinkedHashSet<IEpisodeSchedule> episodeSchedules, Map<IWorkSlot, Set<IEpisodeSchedule>> slotAssignment) {
        HashMap episodeSlots = Maps.newHashMap();
        for (IEpisodeSchedule iEpisodeSchedule : episodeSchedules) {
            episodeSlots.put(iEpisodeSchedule, Sets.newHashSet());
        }
        for (Map.Entry entry : slotAssignment.entrySet()) {
            IWorkSlot slot = (IWorkSlot)entry.getKey();
            Set slotSchedules = (Set)entry.getValue();
            for (IEpisodeSchedule slotSchedule : slotSchedules) {
                RmUtils.addToKeyedSets(episodeSlots, slotSchedule, slot);
            }
        }
        return episodeSlots;
    }

    private Map<IEpisodeSchedule, Set<IWorkSlotData>> createEpisodeToSlotStatsMap(LinkedHashSet<IEpisodeSchedule> episodeSchedules, Map<IWorkSlot, Set<IEpisodeSchedule>> slotAssignment, BiMap<IWorkSlot, IWorkSlotData> slotStatisitics) {
        HashMap episodeToSlotStats = Maps.newHashMap();
        for (IEpisodeSchedule iEpisodeSchedule : episodeSchedules) {
            episodeToSlotStats.put(iEpisodeSchedule, Sets.newHashSet());
        }
        for (Map.Entry entry : slotAssignment.entrySet()) {
            IWorkSlot slot = (IWorkSlot)entry.getKey();
            Set slotSchedules = (Set)entry.getValue();
            for (IEpisodeSchedule episodeSchedule : slotSchedules) {
                RmUtils.addToKeyedSets(episodeToSlotStats, episodeSchedule, slotStatisitics.get((Object)slot));
            }
        }
        return episodeToSlotStats;
    }

    private Map<IWorkSlot, IResourceGroup> getSlotGroupMap(Set<IResourceGroup> resourceGroups, int endTime) {
        HashMap workSlots = Maps.newHashMap();
        for (IResourceGroup group : resourceGroups) {
            List<IWorkSlot> slotsOfGroup = group.getWorkSlotsBetween(0, endTime);
            for (IWorkSlot slot : slotsOfGroup) {
                workSlots.put(slot, group);
            }
        }
        return workSlots;
    }

    private static Map<IWorkSlot, Set<IEpisodeSchedule>> createEpisodeToSlotStatsMap(LinkedHashSet<IEpisodeSchedule> episodeSchedules, Set<IWorkSlot> workSlots) {
        HashMap map = Maps.newHashMap();
        for (IEpisodeSchedule schedule : episodeSchedules) {
            IEpisode episode = schedule.getEpisode();
            int end = schedule.getEnd();
            if (episode.getFixedEndTime().isPresent()) {
                end = (Integer)episode.getFixedEndTime().get();
            }
            IntegerInterval interval = new IntegerInterval(schedule.getReleaseTime(), end);
            Set<IWorkSlot> contained = RmUtils.getContainedIntervals(interval, workSlots);
            for (IWorkSlot slot : contained) {
                RmUtils.addToKeyedSets(map, slot, schedule);
            }
        }
        return map;
    }

    private static Map<IWorkSlot, Set<IWorkAssignment>> getWorkSlotMap(Set<IWorkAssignment> workAssignments) {
        HashMap map = Maps.newHashMap();
        for (IWorkAssignment assignment : workAssignments) {
            IWorkSlot slot = assignment.getWorkSlot();
            RmUtils.addToKeyedSets(map, slot, assignment);
        }
        return map;
    }
}

