/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.stats;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IWorkSlotData;
import java.util.List;

class WorkSlotStatistics
implements IWorkSlotData {
    private final IWorkSlot workSlot;
    private final List<IResourceType> bottleneckTypes;
    private final double avgResourceUtilization;
    private final double workLoad;
    private final PositivePrimitivesMap<IResourceType> freeTypes;
    private final double availableWork;
    private final PositivePrimitivesMap<IResourceType> bottleneckWeights;

    private WorkSlotStatistics(IWorkSlot workSlot, List<IResourceType> bottleneckTypes, PositivePrimitivesMap<IResourceType> bottleneckWeights, double avgResourceUtilization, double workLoad, PositivePrimitivesMap<IResourceType> freeTypes, double availableWork) {
        this.workSlot = workSlot;
        this.bottleneckTypes = bottleneckTypes;
        this.avgResourceUtilization = avgResourceUtilization;
        this.workLoad = workLoad;
        this.freeTypes = freeTypes;
        this.availableWork = availableWork;
        this.bottleneckWeights = bottleneckWeights;
    }

    @Override
    public String getGroupId() {
        return this.workSlot.getGroupId();
    }

    @Override
    public Optional<String> getSlotTitle() {
        return this.workSlot.tryGetId();
    }

    @Override
    public int getIndex() {
        return this.workSlot.getIndex();
    }

    @Override
    public List<IResourceType> getPriorizedBottleneckResourceTypes() {
        return this.bottleneckTypes;
    }

    @Override
    public String getTeamId() {
        return this.workSlot.getGroupId();
    }

    @Override
    public double getAvgResourceUtilization() {
        return this.avgResourceUtilization;
    }

    @Override
    public double getWorkLoad() {
        return this.workLoad;
    }

    @Override
    public List<IResourceType> getFreeCapacitiesOfResourceTypes() {
        return RmUtils.getReverseOrderWithNumericalValues(this.freeTypes);
    }

    @Override
    public double getAvailableWork() {
        return this.availableWork;
    }

    @Override
    public PositivePrimitivesMap<IResourceType> getFreeTypes() {
        return this.freeTypes;
    }

    @Override
    public int getStart() {
        return this.workSlot.getStart();
    }

    @Override
    public int getEnd() {
        return this.workSlot.getEnd();
    }

    @Override
    public int getLength() {
        return this.workSlot.getLength();
    }

    @Override
    public boolean contains(int value) {
        return this.workSlot.contains(value);
    }

    @Override
    public Optional<IIntegerInterval> getOverlappingInterval(IIntegerInterval interval) {
        return this.workSlot.getOverlappingInterval(interval);
    }

    @Override
    public PositivePrimitivesMap<IResourceType> getBottleneckWeights() {
        return this.bottleneckWeights;
    }

    @Override
    public IWorkSlot getWorkSlot() {
        return this.workSlot;
    }

    static WorkSlotStatistics create(IWorkSlot workSlot, List<IResourceType> bottleneckTypes, PositivePrimitivesMap<IResourceType> bottleneckWeights, double avgResourceUtilization, double workLoad, PositivePrimitivesMap<IResourceType> freeTypes, double availableWork) {
        return new WorkSlotStatistics(workSlot, bottleneckTypes, bottleneckWeights, avgResourceUtilization, workLoad, freeTypes, availableWork);
    }
}

