/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IRoadmapSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositiveTroveMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.people.IterationStartType;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IRoadmapStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IWorkSlotData;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.GroupIntervalCapacityStatistic;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.GroupIntervalStatisticImpl;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.ResourceIntervalCapacityStatistic;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.ResourceIntervalCapacityStatisticCalculator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class GroupIntervalCapacityStatisticCalculator {
    private static final int AGGREGATION = 7;
    private final ResourceIntervalCapacityStatisticCalculator resourceIntervalCapacityStatisticCalculator;
    private final ITimeTransformer timeTransformer;

    public GroupIntervalCapacityStatisticCalculator(ITimeTransformer timeTransformer) {
        this(new ResourceIntervalCapacityStatisticCalculator(), timeTransformer);
    }

    GroupIntervalCapacityStatisticCalculator(ResourceIntervalCapacityStatisticCalculator resourceIntervalCapacityStatisticCalculator, ITimeTransformer timeTransformer) {
        this.resourceIntervalCapacityStatisticCalculator = resourceIntervalCapacityStatisticCalculator;
        this.timeTransformer = timeTransformer;
    }

    public List<GroupIntervalCapacityStatistic> calculateIntervalStatistics(IResourceGroup group, IRoadmapSchedule solution, IRoadmapStatistics roadmapStatistics) {
        ArrayList statistics = Lists.newArrayList();
        List<IWorkSlot> slots = group.getWorkSlotsBetween(0, solution.getAnalysisEndTime());
        if (slots.isEmpty()) {
            return statistics;
        }
        for (IWorkSlot slot : slots) {
            statistics.add(this.calculateIntervalStatistic(group, slot, solution, roadmapStatistics));
        }
        if (group.isWorkSlotStrict()) {
            return statistics;
        }
        return this.aggregateStatistics(statistics);
    }

    private List<GroupIntervalCapacityStatistic> aggregateStatistics(List<GroupIntervalCapacityStatistic> statistics) {
        ArrayList aggregatedStatistics = Lists.newArrayList();
        int index = 0;
        for (List<GroupIntervalCapacityStatistic> partition : this.getPartitions(statistics)) {
            aggregatedStatistics.add(this.aggregate(partition, index));
            ++index;
        }
        return aggregatedStatistics;
    }

    private List<List<GroupIntervalCapacityStatistic>> getPartitions(List<GroupIntervalCapacityStatistic> statistics) {
        int offset = this.timeTransformer.getNextTimeStep(IterationStartType.OnMondays);
        return RmCollectionUtils.getPartitions(statistics, offset, 7);
    }

    private GroupIntervalCapacityStatistic aggregate(final List<GroupIntervalCapacityStatistic> partition, final int index) {
        return new GroupIntervalCapacityStatistic(){

            @Override
            public int getStart() {
                return ((GroupIntervalCapacityStatistic)partition.get(0)).getStart();
            }

            @Override
            public int getEnd() {
                return ((GroupIntervalCapacityStatistic)partition.get(partition.size() - 1)).getEnd();
            }

            @Override
            public List<IResourceType> getBottleneckTypes() {
                return this.getTypes(Lists.transform((List)partition, (Function)new Function<GroupIntervalCapacityStatistic, PositivePrimitivesMap<IResourceType>>(){

                    public PositivePrimitivesMap<IResourceType> apply(@Nullable GroupIntervalCapacityStatistic statistic) {
                        return statistic.getBottleneckWeights();
                    }
                }));
            }

            @Override
            public PositivePrimitivesMap<IResourceType> getBottleneckWeights() {
                return MutablePositiveTroveMap.create(this.aggregateMap(Lists.transform((List)partition, (Function)new Function<GroupIntervalCapacityStatistic, PositivePrimitivesMap<IResourceType>>(){

                    public PositivePrimitivesMap<IResourceType> apply(@Nullable GroupIntervalCapacityStatistic statistic) {
                        return statistic.getBottleneckWeights();
                    }
                })));
            }

            @Override
            public PositivePrimitivesMap<IResourceType> getFreeWeights() {
                return MutablePositiveTroveMap.create(this.aggregateMap(Lists.transform((List)partition, (Function)new Function<GroupIntervalCapacityStatistic, PositivePrimitivesMap<IResourceType>>(){

                    public PositivePrimitivesMap<IResourceType> apply(@Nullable GroupIntervalCapacityStatistic statistic) {
                        return statistic.getFreeWeights();
                    }
                })));
            }

            private PositivePrimitivesMap<IResourceType> aggregateMap(List<PositivePrimitivesMap<IResourceType>> transform) {
                MutablePositivePrimitivesMap<IResourceType> map = RmCollectionUtils.newMutablePositiveMap();
                for (PositivePrimitivesMap<IResourceType> inputMap : transform) {
                    if (inputMap == null) continue;
                    map.add(inputMap);
                }
                return map;
            }

            private List<IResourceType> getTypes(List<PositivePrimitivesMap<IResourceType>> transform) {
                return RmUtils.getReverseOrderWithNumericalValues(this.aggregateMap(transform));
            }

            @Override
            public Set<ResourceIntervalCapacityStatistic> getResourceIntervalCapacityStatistics() {
                return this.aggregateResourceIntervals(partition);
            }

            private Set<ResourceIntervalCapacityStatistic> aggregateResourceIntervals(List<GroupIntervalCapacityStatistic> partition2) {
                HashMap resourceIdToCapacities = Maps.newHashMap();
                for (GroupIntervalCapacityStatistic statistic : partition2) {
                    for (ResourceIntervalCapacityStatistic resourceStatistic : statistic.getResourceIntervalCapacityStatistics()) {
                        RmUtils.addToKeyedSets(resourceIdToCapacities, resourceStatistic.getId(), resourceStatistic);
                    }
                }
                HashSet aggregated = Sets.newHashSet();
                for (final Set toAggregate : resourceIdToCapacities.values()) {
                    aggregated.add(new ResourceIntervalCapacityStatistic(){

                        @Override
                        public float getCapacity() {
                            float sum = 0.0f;
                            for (ResourceIntervalCapacityStatistic statistic : toAggregate) {
                                sum += statistic.getCapacity();
                            }
                            return sum;
                        }

                        @Override
                        public Set<IWorkAssignment> getWorkAssignments() {
                            HashSet assignments = Sets.newHashSet();
                            for (ResourceIntervalCapacityStatistic statistic : toAggregate) {
                                assignments.addAll(statistic.getWorkAssignments());
                            }
                            return assignments;
                        }

                        @Override
                        public String getId() {
                            return ((ResourceIntervalCapacityStatistic)toAggregate.iterator().next()).getId();
                        }
                    });
                }
                return aggregated;
            }

            @Override
            public int getIndex() {
                return index;
            }

            @Override
            public List<IResourceType> getFreeCapacities() {
                return this.getTypes(Lists.transform((List)partition, (Function)new Function<GroupIntervalCapacityStatistic, PositivePrimitivesMap<IResourceType>>(){

                    public PositivePrimitivesMap<IResourceType> apply(@Nullable GroupIntervalCapacityStatistic statistic) {
                        return statistic.getFreeWeights();
                    }
                }));
            }
        };
    }

    private GroupIntervalCapacityStatistic calculateIntervalStatistic(IResourceGroup group, IWorkSlot slot, IRoadmapSchedule solution, IRoadmapStatistics roadmapStatistics) {
        return new GroupIntervalStatisticImpl(slot, this.getBottlenecks(roadmapStatistics.getWorkSlotStatistics(), slot), this.resourceIntervalCapacityStatisticCalculator.calculateStatistics(group, slot, solution));
    }

    private IWorkSlotData getBottlenecks(Set<IWorkSlotData> workSlotStatistics, final IWorkSlot slot) {
        return (IWorkSlotData)Iterables.find(workSlotStatistics, (Predicate)new Predicate<IWorkSlotData>(){

            public boolean apply(IWorkSlotData statistic) {
                return statistic.getIndex() == slot.getIndex() && statistic.getTeamId().equals(slot.getGroupId());
            }
        });
    }
}

