/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WeeklyWorkDayDefinition;
import com.radiantminds.roadmap.common.data.entities.plans.WeekdayConfiguration;
import org.joda.time.DateTime;

public class PreCalculatedWeeklyWorkDayFunction
implements WeeklyWorkDayDefinition {
    private final int workDaysPerWeek;
    private final int zeroDayOfWeek;
    private final boolean[] isWorkTimeStep;

    private PreCalculatedWeeklyWorkDayFunction(int workDaysPerWeek, int zeroDayOfWeek, boolean[] isWorkTimeStep) {
        this.workDaysPerWeek = workDaysPerWeek;
        this.zeroDayOfWeek = zeroDayOfWeek;
        this.isWorkTimeStep = isWorkTimeStep;
    }

    @Override
    public boolean isWorkTimeStep(int timeStep) {
        return this.isWorkTimeStep[(this.zeroDayOfWeek + timeStep) % 7];
    }

    @Override
    public int getWorkDaysPerWeek() {
        return this.workDaysPerWeek;
    }

    public static PreCalculatedWeeklyWorkDayFunction init(DateTime dateTime, WeekdayConfiguration weekdayConfiguration) {
        return new PreCalculatedWeeklyWorkDayFunction(weekdayConfiguration.getWorkingDaysCount(), dateTime.getDayOfWeek() - 1, weekdayConfiguration.getMondayStartingBooleans());
    }
}

