/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.MissingWorkTypeViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.IResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.RmSchedulingUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.IEpicSkillsViolationDetector;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
class EpicSkillsViolationDetector
implements IEpicSkillsViolationDetector {
    EpicSkillsViolationDetector() {
    }

    @Override
    public Optional<IScheduleViolation> tryFindMissingSkillViolation(String workItemId, Set<IResourceType> specifiedResourceTypes, AssignmentRestriction assignment) {
        HashSet missingTypes = Sets.newHashSet(specifiedResourceTypes);
        for (IResourcePool pool : assignment.getResourcePools()) {
            Set<IWorkResource> resources = pool.getResources();
            Set<IResourceType> availableTypes = RmSchedulingUtils.getMergedResourceTypes(resources);
            missingTypes.removeAll(availableTypes);
        }
        if (!missingTypes.isEmpty()) {
            MissingWorkTypeViolation scheduleViolation = new MissingWorkTypeViolation(workItemId, missingTypes);
            return Optional.of((Object)scheduleViolation);
        }
        return Optional.absent();
    }
}

