/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.MissingWorkTypePerTeamViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.MissingWorkTypeViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import java.util.HashMap;

class NoAssignmentPoolViolationDetector {
    NoAssignmentPoolViolationDetector() {
    }

    IScheduleViolation handleInvalidAssignment(IAggregatedWorkPackage workDemand, SchedulingWorkItem workItem) {
        if (!workItem.getTeamId().isPresent()) {
            return new MissingWorkTypeViolation(workItem.getId(), workDemand.getResourceTypes());
        }
        if (WorkItems.Types.EPIC.equals(workItem.getType())) {
            return new MissingWorkTypeViolation(workItem.getId(), workDemand.getResourceTypes());
        }
        HashMap missingsMap = Maps.newHashMap();
        missingsMap.put(workItem.getTeamId().get(), RmIdentifiableUtils.getIds(workDemand.getResourceTypes()));
        return new MissingWorkTypePerTeamViolation(workItem.getId(), missingsMap, workItem.getResourceIds());
    }
}

