/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.ValidWorkItemPredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class PriorizedWorkItemsProvider {
    private static final Log LOGGER = Log.with(PriorizedWorkItemsProvider.class);

    PriorizedWorkItemsProvider() {
    }

    List<SchedulingWorkItem> getValidSortedWorkItems(List<? extends SchedulingWorkItem> unsorted) {
        Preconditions.checkNotNull(unsorted, (Object)"collection to sort must not be null");
        LOGGER.debug("get valid sorted work items", new Object[0]);
        Iterable filteredUnsorted = Iterables.filter(unsorted, (Predicate)new ValidWorkItemPredicate());
        ArrayList sorted = Lists.newArrayList((Iterable)filteredUnsorted);
        Collections.sort(sorted, new Comparator<SchedulingWorkItem>(){

            @Override
            public int compare(SchedulingWorkItem s1, SchedulingWorkItem s2) {
                Long order1 = s1.getSortOrder();
                Long order2 = s2.getSortOrder();
                return Longs.compare((long)order1, (long)order2);
            }
        });
        LOGGER.debug("valid sorted work items: %s", Joiner.on((String)",").join((Iterable)sorted));
        return sorted;
    }
}

