/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import java.util.Set;

class TransitiveEarliestStartTimeCalculator {
    TransitiveEarliestStartTimeCalculator() {
    }

    long getTransitiveEarliestStart(SchedulingWorkItem workItem, Set<SchedulingWorkItem> transitivePrerequisites, SchedulingPlan plan) {
        long maxReleaseTime = (Long)Optional.fromNullable((Object)workItem.getEarliestStart()).or((Object)0L);
        SchedulingWorkItem parent = (SchedulingWorkItem)plan.getWorkItem(workItem.getParentId()).orNull();
        if (parent != null && parent.getEarliestStart() != null && workItem.getEarliestStart() == null) {
            maxReleaseTime = Math.max(maxReleaseTime, parent.getEarliestStart());
        }
        for (SchedulingWorkItem prerequisite : transitivePrerequisites) {
            if (prerequisite.getEarliestStart() == null) continue;
            maxReleaseTime = Math.max(maxReleaseTime, prerequisite.getEarliestStart());
        }
        return maxReleaseTime;
    }
}

