/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.AggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimationEnrichedWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingEstimate;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.scheduling.common.TimeAmountTransformer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

class WorkDemandCalculator {
    private static final Log LOGGER = Log.with(WorkDemandCalculator.class);
    private final TimeAmountTransformer timeAmountTransformer;

    WorkDemandCalculator(TimeAmountTransformer timeAmountTransformer) {
        this.timeAmountTransformer = timeAmountTransformer;
    }

    Optional<IAggregatedWorkPackage> tryCreateWorkDemand(SchedulingWorkItem workItem, List<IProcessingStage> processingStages) {
        LOGGER.debug("create work demand for epic: %s", workItem);
        LinkedHashMap stageToWorkDemandMap = Maps.newLinkedHashMap();
        for (IProcessingStage processingStage : processingStages) {
            PositivePrimitivesMap<IResourceType> stageDemandMap;
            Optional<IProcessingStageWorkPackage> stageDemands = ProcessingStageWorkPackage.tryCreateFromDemandMap(processingStage, stageDemandMap = this.createWorkDemandMap(workItem, processingStage));
            if (!stageDemands.isPresent()) continue;
            stageToWorkDemandMap.put(processingStage, stageDemands.get());
        }
        return AggregatedWorkPackage.tryCreateInstance(stageToWorkDemandMap);
    }

    private PositivePrimitivesMap<IResourceType> createWorkDemandMap(SchedulingWorkItem estimable, IProcessingStage processingStage) {
        Optional<SchedulingEstimate> itemEstimate = estimable.getTotalEstimate();
        if (itemEstimate.isPresent()) {
            float overallDemand = ((SchedulingEstimate)itemEstimate.get()).getEstimate().floatValue();
            float overallStageDemand = overallDemand * processingStage.getDefaultPercentage();
            return this.caculateDemandMap(overallStageDemand, processingStage);
        }
        Optional<? extends SchedulingEstimate> stageEstimate = estimable.getEstimateForStage(processingStage.getId());
        if (stageEstimate.isPresent()) {
            float overallStageDemand = ((SchedulingEstimate)stageEstimate.get()).getEstimate().floatValue();
            return this.caculateDemandMap(overallStageDemand, processingStage);
        }
        return this.handleSkillLevelEstimate(estimable, processingStage);
    }

    private PositivePrimitivesMap<IResourceType> caculateDemandMap(float overallStageDemand, IProcessingStage processingStage) {
        Set<IResourceType> resourceTypes = processingStage.getResourceTypes();
        MutablePositivePrimitivesMap<IResourceType> demandMap = RmCollectionUtils.newMutablePositiveMap(resourceTypes.size());
        for (IResourceType resourceType : resourceTypes) {
            float percentage = resourceType.getPercentageWithinProcessingStage();
            float workDemand = this.timeAmountTransformer.getNormalizedWorkDemand(percentage * overallStageDemand);
            if (workDemand <= 0.0f) {
                LOGGER.debug("calculated non-positive work demand for skill: %s", resourceType);
                continue;
            }
            demandMap.put(resourceType, workDemand);
        }
        LOGGER.debug("created demand map with %s non-zero entries", demandMap.size());
        return demandMap;
    }

    private PositivePrimitivesMap<IResourceType> handleSkillLevelEstimate(SchedulingWorkItem workItem, IProcessingStage processingStage) {
        Set<IResourceType> resourceTypes = processingStage.getResourceTypes();
        MutablePositivePrimitivesMap<IResourceType> demandMap = RmCollectionUtils.newMutablePositiveMap(resourceTypes.size());
        for (IResourceType resourceType : resourceTypes) {
            Optional<? extends SchedulingEstimate> estimate = workItem.getEstimateForSkill(resourceType.getId());
            if (!estimate.isPresent()) {
                LOGGER.trace("found empty skill entry", new Object[0]);
                continue;
            }
            float workDemand = this.timeAmountTransformer.getNormalizedWorkDemand(((SchedulingEstimate)estimate.get()).getEstimate().floatValue());
            if (workDemand <= 0.0f) {
                LOGGER.debug("skip empty demand for resource type: %s", resourceType);
                continue;
            }
            demandMap.put(resourceType, workDemand);
            LOGGER.debug("add estimation for resource type %s: %s", resourceType, Float.valueOf(workDemand));
        }
        LOGGER.debug("created demand map with %s non-zero entries", demandMap.size());
        return demandMap;
    }

    Optional<IProcessingStageWorkPackage> tryCreateStageWorkDemand(IEstimationEnrichedWorkItem workItem, IProcessingStage processingStage) {
        LOGGER.debug("create work demand map for stage %s of story %s", new Object[0]);
        PositivePrimitivesMap<IResourceType> demandMap = this.createWorkDemandMap(workItem, processingStage);
        return ProcessingStageWorkPackage.tryCreateFromDemandMap(processingStage, demandMap);
    }
}

