/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.settings;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ResourceType;
import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.radiantminds.roadmap.common.data.entities.skills.SchedulingSkill;
import com.radiantminds.roadmap.common.data.entities.skills.SchedulingStage;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.IResourceTypeMapping;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.ResourceTypeMapping;
import java.util.List;
import java.util.Map;

class ResourceTypeCreator {
    private static final Log LOGGER = Log.with(ResourceTypeCreator.class);
    private static final String DUMMY_ID_PREFIX = "stageSkill-";

    ResourceTypeCreator() {
    }

    IResourceTypeMapping createSkillToTypeBiMap(List<? extends SchedulingStage> stages, Map<SchedulingSkill, Float> skillToPercentageMap) {
        LOGGER.debug("extract skills from stages: %s", Joiner.on((String)",").join(stages));
        HashBiMap skillToTypeMap = HashBiMap.create();
        HashBiMap stageToTypeMap = HashBiMap.create();
        for (SchedulingStage schedulingStage : stages) {
            List<? extends SchedulingSkill> skills = schedulingStage.getSkills();
            if (skills == null || skills.isEmpty()) {
                String dummyId = DUMMY_ID_PREFIX + schedulingStage.getId();
                ResourceType type = new ResourceType(dummyId, 1.0f, schedulingStage.getId(), dummyId, true, "0");
                stageToTypeMap.put((Object)schedulingStage, (Object)type);
                continue;
            }
            String stageSort = schedulingStage.getSortOrder().toString();
            for (SchedulingSkill schedulingSkill : skills) {
                String id = schedulingSkill.getId();
                float percentage = skillToPercentageMap.get(schedulingSkill).floatValue();
                String sortKey = stageSort + "-" + schedulingSkill.getSortOrder().toString();
                ResourceType type = new ResourceType(id, percentage, schedulingStage.getId(), null, false, sortKey);
                skillToTypeMap.put((Object)schedulingSkill, (Object)type);
            }
        }
        return new ResourceTypeMapping((BiMap<SchedulingStage, IResourceType>)stageToTypeMap, (BiMap<SchedulingSkill, IResourceType>)skillToTypeMap);
    }
}

