/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.common;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IntervalPadding;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.VariableScrumWorkSlots;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.util.IdentifiableInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.SprintDefinitionTransformer;
import java.util.List;
import javax.annotation.Nullable;

public class ScrumSprintTransformer {
    private final TimeStepPresenceFunction timeStepPresenceFunction;
    private final SprintDefinitionTransformer filter;
    private final IntervalPadding intervalPadding;
    private final ITimeTransformer timeTransformer;

    public ScrumSprintTransformer(ITimeTransformer timeTransformer, TimeStepPresenceFunction timeStepPresenceFunction) {
        this(new SprintDefinitionTransformer(timeTransformer), new IntervalPadding(), timeStepPresenceFunction, timeTransformer);
    }

    ScrumSprintTransformer(SprintDefinitionTransformer filter, IntervalPadding intervalPadding, TimeStepPresenceFunction timeStepPresenceFunction, ITimeTransformer timeTransformer) {
        this.filter = filter;
        this.intervalPadding = intervalPadding;
        this.timeStepPresenceFunction = timeStepPresenceFunction;
        this.timeTransformer = timeTransformer;
    }

    public WorkSlotsDefinition createWorkSlotDefinition(SchedulingTeam team, @Nullable Integer defaultWeekCount) {
        List<IdentifiableInterval> filteredDefinitions = this.filter.transformSprints(team.getSprints());
        List<IIntegerInterval> paddedIntervals = this.intervalPadding.createPaddingIntervals(filteredDefinitions, ScrumSprintTransformer.getWeeksPerSprint(team, defaultWeekCount) * 7, this.timeTransformer.getNextTimeStep(team.getIterationStartType()));
        return VariableScrumWorkSlots.create(team.getId(), filteredDefinitions, paddedIntervals, this.timeStepPresenceFunction, ScrumSprintTransformer.getWeeksPerSprint(team, defaultWeekCount));
    }

    static int getWeeksPerSprint(SchedulingTeam team, @Nullable Integer defaultWeekCount) {
        Integer teamWeeks = team.getWeeksPerSprint();
        if (teamWeeks != null) {
            return teamWeeks;
        }
        if (defaultWeekCount != null && defaultWeekCount > 0) {
            return defaultWeekCount;
        }
        return 2;
    }
}

