/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.utils.dependencies;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.rest.entities.workitems.dependencies.RestDependencyWorkItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DependencyUtils {
    public static List<String> getRealDependencies(List<RestDependencyWorkItem> dependencyWorkItems) {
        return DependencyUtils.getRealDependencies(dependencyWorkItems, new ArrayList<String>());
    }

    public static List<String> getRealDependencies(List<RestDependencyWorkItem> dependencyWorkItems, List<String> ignoreList) {
        ArrayList realDependencies = Lists.newArrayList();
        if (dependencyWorkItems != null) {
            for (RestDependencyWorkItem dependencyWorkItem : dependencyWorkItems) {
                DependencyUtils.addNestedDependencies(realDependencies, dependencyWorkItem, ignoreList);
            }
        }
        return realDependencies;
    }

    public static List<String> getLinkedIssueKeysForWorkItemIds(PortfolioExtensionLinkPersistence extensionLinkPersistence, List<String> workItemIds) throws SQLException {
        ArrayList issueKeys = Lists.newArrayList();
        for (String requiredWorkItemId : workItemIds) {
            List<IExtensionLink> inwardWorkItemLinks = extensionLinkPersistence.getLinksForTarget(AOWorkItem.class, requiredWorkItemId);
            if (inwardWorkItemLinks == null) continue;
            for (IExtensionLink link : inwardWorkItemLinks) {
                issueKeys.add(link.getExtensionLink());
            }
        }
        return issueKeys;
    }

    private static void addNestedDependencies(List<String> dependencies, RestDependencyWorkItem dependencyWorkItem, List<String> ignoreList) {
        if (dependencyWorkItem.getRealDependency().booleanValue() && !ignoreList.contains(dependencyWorkItem.getId())) {
            dependencies.add(dependencyWorkItem.getId());
        }
        if (dependencyWorkItem.getChildren() != null) {
            for (RestDependencyWorkItem childDependencyWorkItem : dependencyWorkItem.getChildren()) {
                DependencyUtils.addNestedDependencies(dependencies, childDependencyWorkItem, ignoreList);
            }
        }
    }
}

