/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.utils.estimate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.skills.ISkill;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

final class EstimateSuggestionTools {
    private EstimateSuggestionTools() {
    }

    static Map<String, Double> computeStagePercentages(IPlan plan) {
        HashMap stagePercentages = Maps.newHashMap();
        double stagesWithoutPercentages = 0.0;
        double stagePercentageSums = 0.0;
        for (IStage stage : plan.getStages()) {
            if (stage.getPercentage() != null) {
                stagePercentages.put(stage.getId(), stage.getPercentage());
                stagePercentageSums += stage.getPercentage().doubleValue();
                continue;
            }
            stagesWithoutPercentages += 1.0;
        }
        double remainingPercentages = Math.max(0.0, 1.0 - stagePercentageSums);
        double computedStagePercentage = 0.0;
        if (remainingPercentages > 0.0) {
            computedStagePercentage = remainingPercentages / stagesWithoutPercentages;
        }
        for (IStage stage : plan.getStages()) {
            if (stagePercentages.containsKey(stage.getId())) continue;
            stagePercentages.put(stage.getId(), computedStagePercentage);
        }
        return stagePercentages;
    }

    static Map<String, Double> sumSkillEstimatesPerStage(IPlan plan, Map<String, IEstimate> skillEstimates) {
        HashMap skillEstimatesPerStage = Maps.newHashMap();
        for (IStage stage : plan.getStages()) {
            double total = 0.0;
            for (ISkill skill : stage.getSkills()) {
                if (!skillEstimates.containsKey(skill.getId())) continue;
                total += skillEstimates.get(skill.getId()).getEstimate().doubleValue();
            }
            skillEstimatesPerStage.put(stage.getId(), total);
        }
        return skillEstimatesPerStage;
    }

    static Map<String, Map<String, Double>> computeSkillEstimatePercentageAllocationsPerStage(IPlan plan, Map<String, IEstimate> skillEstimates, Map<String, Double> skillEstimateSums) {
        HashMap retVal = Maps.newHashMap();
        for (IStage stage : plan.getStages()) {
            Double totalForStage = skillEstimateSums.get(stage.getId());
            for (ISkill skill : stage.getSkills()) {
                if (!retVal.containsKey(stage.getId())) {
                    retVal.put(stage.getId(), Maps.newHashMap());
                }
                if (skillEstimates.containsKey(skill.getId())) {
                    double percentage = skillEstimates.get(skill.getId()).getEstimate() / totalForStage;
                    ((Map)retVal.get(stage.getId())).put(skill.getId(), percentage);
                    continue;
                }
                ((Map)retVal.get(stage.getId())).put(skill.getId(), 0.0);
            }
        }
        return retVal;
    }

    static double sumAllEstimates(Double total, Collection<IEstimate> skills, Collection<IEstimate> stages) {
        if (total != null) {
            return total;
        }
        double sum = 0.0;
        for (IEstimate e : skills) {
            sum += e.getEstimate().doubleValue();
        }
        for (IEstimate e : stages) {
            sum += e.getEstimate().doubleValue();
        }
        return sum;
    }

    static boolean hasSkillEstimates(IStage stage, Set<String> skillEstimateKeySet) {
        ArrayList skillIdsInStage = Lists.newArrayList();
        for (ISkill skill : stage.getSkills()) {
            skillIdsInStage.add(skill.getId());
        }
        for (String skillId : skillEstimateKeySet) {
            if (!skillIdsInStage.contains(skillId)) continue;
            return true;
        }
        return false;
    }
}

