/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.utils.estimate;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.skills.ISkill;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimate;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimateBlock;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimationEnrichedWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EstimateUtil {
    private static final Log LOGGER = Log.with(EstimateUtil.class);
    private final PortfolioEstimatePersistence estimatePersistence;

    public EstimateUtil(PortfolioEstimatePersistence estimatePersistence) {
        this.estimatePersistence = estimatePersistence;
    }

    public Double getTotalEstimate(IWorkItem workItem, EstimateType estimateType, List<IStage> stages, Map<String, Double> stagePercentages, Optional<IStage> stage, boolean recursive) throws Exception {
        if (recursive && workItem.getChildren() != null && workItem.getChildren().size() > 0) {
            Double retVal = 0.0;
            for (IWorkItem iWorkItem : workItem.getChildren()) {
                retVal = retVal + this.getTotalEstimate(iWorkItem, estimateType, stages, stagePercentages, stage, recursive);
            }
            return retVal;
        }
        IEstimateBlock estimates = this.getWorkItemEstimatesForType(workItem, estimateType);
        if (stage.isPresent()) {
            return EstimateUtil.getStageEstimateSum((IStage)stage.get(), estimates, stagePercentages);
        }
        return EstimateUtil.getTotalEstimateSum(estimates, stages);
    }

    public Map<EstimateType, Double> computeEstimates(IWorkItem workItem, Optional<IStage> stage, List<IStage> stages, Map<String, Double> stagePercentages, boolean recursive) throws Exception {
        HashMap retVal = Maps.newHashMap();
        LOGGER.info("Computing estimates...", new Object[0]);
        if (EstimateUtil.hasOriginalEstimates(workItem)) {
            Double remainingEstimate = this.getTotalEstimate(workItem, EstimateType.CURRENT, stages, stagePercentages, stage, recursive);
            Double originalEstimate = this.getTotalEstimate(workItem, EstimateType.ORIGINAL, stages, stagePercentages, stage, recursive);
            retVal.put(EstimateType.ORIGINAL, originalEstimate);
            retVal.put(EstimateType.CURRENT, remainingEstimate);
        } else {
            Double currentEstimate = this.getTotalEstimate(workItem, EstimateType.CURRENT, stages, stagePercentages, stage, recursive);
            retVal.put(EstimateType.CURRENT, currentEstimate);
        }
        return retVal;
    }

    private static boolean hasOriginalEstimates(IWorkItem item) {
        if (item.getHasOriginalEstimates().booleanValue()) {
            return true;
        }
        if (item.getChildren() != null) {
            for (IWorkItem iWorkItem : item.getChildren()) {
                if (!EstimateUtil.hasOriginalEstimates(iWorkItem)) continue;
                return true;
            }
        }
        return false;
    }

    private IEstimateBlock getWorkItemEstimatesForType(IWorkItem workItem, EstimateType estimateType) throws Exception {
        if (workItem instanceof IEstimationEnrichedWorkItem) {
            IEstimationEnrichedWorkItem niceWorkItem = (IEstimationEnrichedWorkItem)workItem;
            if (estimateType == EstimateType.CURRENT) {
                return niceWorkItem.getCurrentEstimates();
            }
            if (EstimateUtil.hasOriginalEstimates(niceWorkItem)) {
                return niceWorkItem.getOriginalEstimates();
            }
            return niceWorkItem.getCurrentEstimates();
        }
        if (estimateType == EstimateType.CURRENT) {
            return this.estimatePersistence.getCurrentEstimates(workItem.getId());
        }
        if (EstimateUtil.hasOriginalEstimates(workItem)) {
            return this.estimatePersistence.getOriginalEstimates(workItem.getId());
        }
        return this.estimatePersistence.getCurrentEstimates(workItem.getId());
    }

    public static Double getTotalEstimateSum(IEstimateBlock estimates, List<IStage> stages) {
        if (estimates.getTotal().isPresent()) {
            return ((IEstimate)estimates.getTotal().get()).getEstimate();
        }
        double retVal = 0.0;
        for (IStage stageEntry : stages) {
            Optional<IEstimate> estimateOnStage = estimates.getEstimateForStage(stageEntry.getId());
            if (estimateOnStage.isPresent()) {
                retVal += ((IEstimate)estimateOnStage.get()).getEstimate().doubleValue();
                continue;
            }
            if (stageEntry.getSkills() == null || stageEntry.getSkills().size() <= 0) continue;
            for (ISkill skill : stageEntry.getSkills()) {
                Optional<IEstimate> estimateOnSkill = estimates.getEstimateForSkill(skill.getId());
                if (!estimateOnSkill.isPresent()) continue;
                retVal += ((IEstimate)estimateOnSkill.get()).getEstimate().doubleValue();
            }
        }
        return retVal;
    }

    public static Double getStageEstimateSum(IStage stage, IEstimateBlock estimates, Map<String, Double> stagePercentages) {
        if (estimates.getTotal().isPresent()) {
            return ((IEstimate)estimates.getTotal().get()).getEstimate() * stagePercentages.get(stage.getId());
        }
        Optional<IEstimate> estimateOnStage = estimates.getEstimateForStage(stage.getId());
        if (estimateOnStage.isPresent()) {
            return ((IEstimate)estimateOnStage.get()).getEstimate();
        }
        if (stage.getSkills() != null && stage.getSkills().size() > 0) {
            Double retVal = 0.0;
            for (ISkill skill : stage.getSkills()) {
                Optional<IEstimate> estimateOnSkill = estimates.getEstimateForSkill(skill.getId());
                if (!estimateOnSkill.isPresent()) continue;
                retVal = retVal + ((IEstimate)estimateOnSkill.get()).getEstimate();
            }
            return retVal;
        }
        return 0.0;
    }

    public static enum EstimateType {
        CURRENT,
        ORIGINAL;

    }
}

