/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.utils.stages;

import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StagePercentageUtil {
    public static final Map<String, Double> computeStagePercentages(List<IStage> stages) {
        HashMap<String, Double> retVal = new HashMap<String, Double>();
        ArrayList<IStage> remainingStages = new ArrayList<IStage>();
        double fixedSetPercentage = 0.0;
        for (IStage stage : stages) {
            if (stage.getPercentage() != null) {
                retVal.put(stage.getId(), stage.getPercentage());
                fixedSetPercentage += stage.getPercentage().doubleValue();
                continue;
            }
            remainingStages.add(stage);
        }
        double dynamicPercentage = (1.0 - fixedSetPercentage) / (double)remainingStages.size();
        for (IStage stage : remainingStages) {
            retVal.put(stage.getId(), dynamicPercentage);
        }
        return retVal;
    }
}

