/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.agile;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.availability.AgileAvailabilityService;
import com.atlassian.rm.common.bridges.agile.license.AgileLicenseServiceBridge;
import com.atlassian.rm.common.bridges.agile.license.AgileLicenseServiceBridgeProxy;
import com.atlassian.rm.common.bridges.jira.roles.UserRoleServiceBridge;
import com.atlassian.rm.common.bridges.jira.roles.UserRoleServiceBridgeProxy;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.jira.common.components.agile.JiraAgileAccessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultJiraAgileAccessor
implements JiraAgileAccessor {
    private static final Log LOGGER = Log.with(DefaultJiraAgileAccessor.class);
    private final JiraAuthenticationContext authenticationContext;
    private final UserRoleServiceBridgeProxy userRoleServiceBridgeProxy;
    private final AgileAvailabilityService agileAvailabilityService;
    private final AgileLicenseServiceBridgeProxy agileLicenseServiceBridgeProxy;

    @Autowired
    public DefaultJiraAgileAccessor(JiraAuthenticationContext authenticationContext, UserRoleServiceBridgeProxy userRoleServiceBridgeProxy, AgileAvailabilityService agileAvailabilityService, AgileLicenseServiceBridgeProxy agileLicenseServiceBridgeProxy) {
        this.authenticationContext = authenticationContext;
        this.userRoleServiceBridgeProxy = userRoleServiceBridgeProxy;
        this.agileAvailabilityService = agileAvailabilityService;
        this.agileLicenseServiceBridgeProxy = agileLicenseServiceBridgeProxy;
    }

    @Override
    public Optional<String> getVersion() {
        return Optional.fromNullable((Object)this.agileAvailabilityService.getVersion());
    }

    @Override
    public boolean isAvailable() {
        return this.agileAvailabilityService.isAgileAvailable();
    }

    @Override
    public boolean isAvailableAndLicensed() {
        try {
            return this.isAvailable() && ((AgileLicenseServiceBridge)this.agileLicenseServiceBridgeProxy.get()).isLicensed();
        }
        catch (AgileNotAvailableException e) {
            LOGGER.debug("Agile not available (after successful availability check). Assuming it is not available.", new Object[0]);
            LOGGER.exception(e, Log.LogLevel.DEBUG);
            return false;
        }
    }

    @Override
    public boolean isRenaissanceEnabled() {
        UserRoleServiceBridge userRoleServiceBridge = (UserRoleServiceBridge)this.userRoleServiceBridgeProxy.get();
        return userRoleServiceBridge.isRenaissanceEnabled();
    }

    @Override
    public boolean isSoftwareUser() {
        ApplicationUser user = this.authenticationContext.getUser();
        if (user == null) {
            return false;
        }
        UserRoleServiceBridge userRoleServiceBridge = (UserRoleServiceBridge)this.userRoleServiceBridgeProxy.get();
        return userRoleServiceBridge.hasSoftwareRole(user);
    }

    @Override
    public boolean isUsable() {
        return this.isAvailableAndLicensed() && this.isSoftwareUser();
    }
}

