/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.create;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldNotAvailableException;
import com.atlassian.rm.common.bridges.jira.issue.IssueManagerBridge;
import com.atlassian.rm.common.bridges.jira.issue.IssueManagerBridgeProxy;
import com.atlassian.rm.common.bridges.jira.project.ProjectManagerBridge;
import com.atlassian.rm.common.bridges.jira.project.ProjectManagerBridgeProxy;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.workitems.CreateIssuePermissionException;
import com.radiantminds.roadmap.common.extensions.workitems.CreateIssueRequest;
import com.radiantminds.roadmap.common.extensions.workitems.CreateIssueResult;
import com.radiantminds.roadmap.jira.common.components.extension.issues.create.CreateIssueException;
import com.radiantminds.roadmap.jira.common.components.utils.TimeTracking;
import com.radiantminds.roadmap.jira.common.components.utils.UnassignedAssignments;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFields;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateIssueRequestHandler {
    private static final Log LOGGER = Log.with(CreateIssueRequestHandler.class);
    private final IssueManager issueManager;
    private final IssueManagerBridgeProxy issueManagerBridgeProxy;
    private final IssueFactory issueFactory;
    private final ProjectManagerBridgeProxy projectManagerBridgeProxy;
    private final ConstantsManager constantsManager;
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private final VersionManager versionManager;
    private final PriorityManager priorityManager;
    private final CustomFields customFields;

    public CreateIssueRequestHandler(IssueManager issueManager, IssueManagerBridgeProxy issueManagerBridgeProxy, IssueFactory issueFactory, ProjectManagerBridgeProxy projectManagerBridgeProxy, ConstantsManager constantsManager, JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, PermissionManager permissionManager, VersionManager versionManager, PriorityManager priorityManager, CustomFields customFields) {
        this.issueManager = issueManager;
        this.issueManagerBridgeProxy = issueManagerBridgeProxy;
        this.issueFactory = issueFactory;
        this.projectManagerBridgeProxy = projectManagerBridgeProxy;
        this.constantsManager = constantsManager;
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.versionManager = versionManager;
        this.priorityManager = priorityManager;
        this.customFields = customFields;
    }

    public CreateIssueResult createIssue(CreateIssueRequest request) throws CreateIssueException, CreateException, AgileNotAvailableException, AgileCustomFieldNotAvailableException, CreateIssuePermissionException {
        Project project;
        ApplicationUser applicationUser = this.authenticationContext.getUser();
        ProjectManagerBridge projectManagerBridge = (ProjectManagerBridge)this.projectManagerBridgeProxy.get();
        Collection authorizedProjects = this.permissionManager.getProjects(11, applicationUser);
        if (!authorizedProjects.contains(project = projectManagerBridge.getProjectObj(request.getProjectId()))) {
            throw new CreateIssuePermissionException();
        }
        MutableIssue issue = this.issueFactory.getIssue();
        issue.setProjectObject(project);
        issue.setIssueTypeObject(this.constantsManager.getIssueTypeObject(request.getIssueTypeId()));
        issue.setReporter(applicationUser);
        Priority priority = this.priorityManager.getDefaultPriority();
        if (priority == null) {
            List priorities = this.priorityManager.getPriorities();
            priority = (Priority)priorities.get((int)Math.floor((priorities.size() - 1) / 2));
        }
        issue.setPriorityObject(priority);
        if (!UnassignedAssignments.isAllowed(this.applicationProperties)) {
            ApplicationUser defaultAssignee = projectManagerBridge.getDefaultAssignee(project, Sets.newHashSet());
            issue.setAssignee(defaultAssignee);
        }
        issue.setSummary(request.getTitle());
        if (request.getDescription() != null) {
            issue.setDescription(request.getDescription());
        }
        if (request.getOriginalEstimate() != null) {
            if (TimeTracking.isEnabled(this.applicationProperties)) {
                issue.setEstimate(request.getOriginalEstimate());
                issue.setOriginalEstimate(request.getOriginalEstimate());
            } else {
                throw new CreateIssueException("Failed to set original estimate due to disabled time tracking.");
            }
        }
        if (request.getFixVersions() != null && request.getFixVersions().size() > 0) {
            ArrayList fixVersions = Lists.newArrayList();
            for (Long fixVersion : request.getFixVersions()) {
                Version version = this.versionManager.getVersion(fixVersion);
                if (version != null) {
                    fixVersions.add(version);
                    continue;
                }
                LOGGER.info("Version for ID %s not found and ignored.", fixVersion);
            }
            if (fixVersions.size() > 0) {
                issue.setFixVersions((Collection)fixVersions);
            }
        }
        if (request.getEpicLabel() != null) {
            CustomField epicLabelField = this.customFields.getEpicLabelCustomField();
            issue.setCustomFieldValue(epicLabelField, (Object)request.getEpicLabel());
        }
        if (request.getEpicLink() != null) {
            MutableIssue epic = this.issueManager.getIssueObject(request.getEpicLink());
            if (epic == null) {
                throw new CreateIssueException("Epic for key '" + request.getEpicLink() + "' not found.");
            }
            CustomField epicLinkField = this.customFields.getEpicLinkCustomField();
            issue.setCustomFieldValue(epicLinkField, (Object)epic);
        }
        if (request.getStoryPoints() != null) {
            CustomField storyPointsField = this.customFields.getStoryPointsCustomField();
            if (storyPointsField.isGlobal() || this.customFields.getAssociatedIssueTypeIds(storyPointsField).contains(request.getIssueTypeId())) {
                issue.setCustomFieldValue(storyPointsField, (Object)request.getStoryPoints());
            } else {
                throw new CreateIssueException("Issue type (" + request.getIssueTypeId() + ") does not allow setting story points.");
            }
        }
        final Issue createdIssue = ((IssueManagerBridge)this.issueManagerBridgeProxy.get()).createIssueObject(applicationUser, (Issue)issue);
        return new CreateIssueResult(){

            @Override
            public String getIssueId() {
                return Long.toString(createdIssue.getId());
            }

            @Override
            public String getIssueKey() {
                return createdIssue.getKey();
            }
        };
    }
}

