/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.workitems.IssueInfo;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.HierarchicalJiraIssueData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.IssueHierarchyResult;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.JiraLinkEnrichmentData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.LinkEnrichmentData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.RetrievedJiraIssue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.jgrapht.Graphs;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.DepthFirstIterator;

@Immutable
class IssueHierarchyJGraphTImpl
implements HierarchicalJiraIssueData {
    private static final Log LOGGER = Log.with(IssueHierarchyJGraphTImpl.class);
    private final DirectedAcyclicGraph<String, DefaultEdge> forest;
    private final Set<String> roots;
    private final IssueHierarchyResult issueHierarchyResult;
    private final Map<String, JiraLinkEnrichmentData> linkEnrichmentDataMap;
    private final Map<String, Set<String>> estimateRatioRelevantRelations;
    private final Map<String, Long> performanceMap;

    IssueHierarchyJGraphTImpl(DirectedAcyclicGraph<String, DefaultEdge> forest, Set<String> roots, IssueHierarchyResult issueHierarchyResult, Map<String, JiraLinkEnrichmentData> linkEnrichmentDataMap, Map<String, Set<String>> estimateRatioRelevantRelations, Map<String, Long> performanceMap) {
        this.forest = forest;
        this.roots = roots;
        this.issueHierarchyResult = issueHierarchyResult;
        this.linkEnrichmentDataMap = linkEnrichmentDataMap;
        this.estimateRatioRelevantRelations = estimateRatioRelevantRelations;
        this.performanceMap = performanceMap;
    }

    @Override
    public Set<String> getSubIssues(String linkId) {
        return Sets.newHashSet(Graphs.successorListOf(this.forest, linkId));
    }

    @Override
    public Set<String> getTransitiveSuccessors(String linkId) {
        HashSet successors = Sets.newHashSet();
        DepthFirstIterator<String, DefaultEdge> iterator = new DepthFirstIterator<String, DefaultEdge>(this.forest, linkId);
        iterator.next();
        while (iterator.hasNext()) {
            successors.add(iterator.next());
        }
        return successors;
    }

    @Override
    public Set<String> getRoots() {
        return this.roots;
    }

    @Override
    public Map<String, JiraLinkEnrichmentData> getIssueInfoByKey() {
        return this.linkEnrichmentDataMap;
    }

    @Override
    public JiraLinkEnrichmentData getIssueData(String link) {
        return this.linkEnrichmentDataMap.get(link);
    }

    @Override
    public Map<String, RetrievedJiraIssue> getIssuesByKey() {
        return this.issueHierarchyResult.getIssuesByKey();
    }

    @Override
    public Map<String, String> getJpoJiraKeyMap() {
        return this.issueHierarchyResult.getJpoJiraKeyMap();
    }

    @Override
    public Map<String, Set<String>> getEstimateRatioRelevantRelations() {
        return this.estimateRatioRelevantRelations;
    }

    static IssueHierarchyJGraphTImpl create(IssueHierarchyResult issueHierarchyResult, Map<String, Long> performanceMap) throws Exception {
        Set<String> allLinks = RmUtils.mergeToSet(issueHierarchyResult.getSubIssueRelationships().values());
        allLinks.addAll(issueHierarchyResult.getSubIssueRelationships().keySet());
        allLinks.addAll(issueHierarchyResult.getIssuesByKey().keySet());
        DirectedAcyclicGraph<String, DefaultEdge> dag = new DirectedAcyclicGraph<String, DefaultEdge>(DefaultEdge.class);
        for (String link : allLinks) {
            dag.addVertex(link);
        }
        Map<String, JiraLinkEnrichmentData> linkDataMap = IssueHierarchyJGraphTImpl.createLinkDataMap(allLinks, issueHierarchyResult.getIssueInfoByKey());
        HashSet rootsTbd = Sets.newHashSet(allLinks);
        Map<String, Set<String>> subIssueRelationships = issueHierarchyResult.getSubIssueRelationships();
        for (Map.Entry<String, Set<String>> entry : subIssueRelationships.entrySet()) {
            String parent = entry.getKey();
            Set<String> children = entry.getValue();
            rootsTbd.removeAll(children);
            for (String child : children) {
                if (dag.containsEdge(parent, child)) continue;
                try {
                    dag.addDagEdge(parent, child);
                }
                catch (DirectedAcyclicGraph.CycleFoundException e) {
                    LOGGER.warn("found cyclic dependency - ignored", new Object[0]);
                }
            }
        }
        IssueHierarchyJGraphTImpl instance = new IssueHierarchyJGraphTImpl(dag, rootsTbd, issueHierarchyResult, linkDataMap, issueHierarchyResult.getUnestimatedCountRelevant(), performanceMap);
        return instance;
    }

    static Map<String, JiraLinkEnrichmentData> createLinkDataMap(Collection<String> allLinks, Map<String, IssueInfo> issueInfoByKey) throws IllegalStateException {
        HashMap linkDataMap = Maps.newHashMap();
        ArrayList noIssueDataLinks = Lists.newArrayList();
        for (String link : allLinks) {
            IssueInfo issueInfo = issueInfoByKey.get(link);
            if (issueInfo != null) {
                JiraLinkEnrichmentData linkData = LinkEnrichmentData.create(issueInfo);
                linkDataMap.put(link, linkData);
                continue;
            }
            noIssueDataLinks.add(link);
        }
        if (!noIssueDataLinks.isEmpty()) {
            String linksString = Joiner.on((String)", ").join((Iterable)noIssueDataLinks);
            LOGGER.error("No issue data retrieved for issue key(s) %s.", linksString);
            throw new IllegalStateException(String.format("No issue data retrieved for issue key(s) %s.", linksString));
        }
        return linkDataMap;
    }
}

