/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldNotAvailableException;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.RetrievedJiraIssue;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFields;
import java.util.Map;

class FailSafeCustomFieldReader {
    private static final Log LOGGER = Log.with(FailSafeCustomFieldReader.class);
    private final CustomField field;
    private final Map<String, RetrievedJiraIssue> linkToIssue;

    FailSafeCustomFieldReader(CustomField field, Map<String, RetrievedJiraIssue> linkToIssue) {
        this.field = field;
        this.linkToIssue = linkToIssue;
    }

    Optional<Double> getCustomFieldValueForIssueId(String issueId) {
        RetrievedJiraIssue issue = this.linkToIssue.get(issueId);
        if (issue == null) {
            LOGGER.debug("unknown issue with id: %s", issueId);
            return Optional.absent();
        }
        Object value = issue.getCustomFieldValue(this.field);
        if (value == null) {
            LOGGER.debug("value for field not set for issue: %s", issueId);
            return Optional.absent();
        }
        return Optional.of((Object)((Double)value));
    }

    public static FailSafeCustomFieldReader createStoryPointReader(CustomFields customFields, Map<String, RetrievedJiraIssue> issues) throws AgileNotAvailableException, AgileCustomFieldNotAvailableException {
        CustomField storyPointsField = customFields.getStoryPointsCustomField();
        return new FailSafeCustomFieldReader(storyPointsField, issues);
    }
}

