/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress;

import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.JiraLinkEnrichmentData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.ExtensionLinkProgress;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.SelfProgressExtractor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
class TimeBasedSelfProgressExtractor
implements SelfProgressExtractor {
    private final boolean doneIsDone;

    TimeBasedSelfProgressExtractor(boolean doneIsDone) {
        this.doneIsDone = doneIsDone;
    }

    @Override
    public Map<String, ProgressData> getProgressData(Map<String, JiraLinkEnrichmentData> issueDataMap) {
        HashMap linkProgresses = Maps.newHashMap();
        for (Map.Entry<String, JiraLinkEnrichmentData> entry : issueDataMap.entrySet()) {
            JiraLinkEnrichmentData issueData = entry.getValue();
            ExtensionLinkProgress progress = ExtensionLinkProgress.createTimeBasedSelfProgress(issueData, this.doneIsDone);
            linkProgresses.put(entry.getKey(), progress);
        }
        return linkProgresses;
    }
}

