/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.search;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.version.Version;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.extensions.workitems.IIssueData;
import com.radiantminds.roadmap.common.extensions.workitems.IIssueRequest;
import com.radiantminds.roadmap.common.extensions.workitems.StatusData;
import com.radiantminds.roadmap.common.extensions.workitems.search.VersionData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.status.JiraIssueStatusData;
import com.radiantminds.roadmap.jira.common.components.utils.IconURLs;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

class IssueData
implements IIssueData {
    private final String key;
    private final String title;
    private final String description;
    private final Long projectId;
    private final Long estimate;
    private final Double storyPoints;
    private final Long issueTypeId;
    private final String issueTypeName;
    private final String issueTypeIconURL;
    private final String epicLink;
    private final StatusData statusData;
    private final List<VersionData> fixVersions;

    private IssueData(String key, String title, String description, Long projectId, Long estimate, Double storyPoints, Long issueTypeId, String issueTypeName, String issueTypeIconURL, String epicLink, List<VersionData> fixVersions, StatusData statusData) {
        this.key = key;
        this.title = title;
        this.description = description;
        this.projectId = projectId;
        this.estimate = estimate;
        this.storyPoints = storyPoints;
        this.issueTypeId = issueTypeId;
        this.issueTypeName = issueTypeName;
        this.issueTypeIconURL = issueTypeIconURL;
        this.epicLink = epicLink;
        this.fixVersions = fixVersions;
        this.statusData = statusData;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Long getProjectId() {
        return this.projectId;
    }

    @Override
    public Long getEstimate() {
        return this.estimate;
    }

    @Override
    public Double getStoryPoints() {
        return this.storyPoints;
    }

    @Override
    public String getIssueTypeName() {
        return this.issueTypeName;
    }

    @Override
    public String getIssueTypeIconURL() {
        return this.issueTypeIconURL;
    }

    @Override
    public Long getIssueTypeId() {
        return this.issueTypeId;
    }

    @Override
    public Optional<String> getEpicLink() {
        return Optional.fromNullable((Object)this.epicLink);
    }

    @Override
    public StatusData getStatusData() {
        return this.statusData;
    }

    @Override
    public List<VersionData> getFixVersions() {
        return this.fixVersions;
    }

    static IssueData createFromIssue(Issue issue, @Nullable IIssueRequest.EstimationMethod estimationMethod, String baseUrl, CustomField epicLinkField, CustomField storyPointField) {
        String key = issue.getKey();
        String title = issue.getSummary();
        String description = issue.getDescription();
        Long projectId = issue.getProjectObject().getId();
        Long issueTypeId = Long.parseLong(issue.getIssueTypeObject().getId());
        String issueTypeName = issue.getIssueTypeObject().getNameTranslation();
        String issueTypeIconURL = IconURLs.adapt(baseUrl, issue.getIssueTypeObject().getIconUrlHtml());
        String epicLink = IssueData.getEpicLink(issue, epicLinkField);
        List<VersionData> fixVersions = IssueData.getFixVersions(issue);
        Long estimate = null;
        Double storyPoints = null;
        if (estimationMethod == IIssueRequest.EstimationMethod.STORY_POINTS) {
            storyPoints = IssueData.getStoryPoints(issue, storyPointField);
        } else if (estimationMethod == IIssueRequest.EstimationMethod.ESTIMATES && (estimate = issue.getEstimate()) == null) {
            estimate = issue.getOriginalEstimate();
        }
        Status status = issue.getStatusObject();
        StatusData statusData = JiraIssueStatusData.createInstance(status, baseUrl);
        IssueData issueData = new IssueData(key, title, description, projectId, estimate, storyPoints, issueTypeId, issueTypeName, issueTypeIconURL, epicLink, fixVersions, statusData);
        return issueData;
    }

    private static String getEpicLink(Issue issue, CustomField epicLinkField) {
        Object epicLinkObject;
        String epicLink = null;
        if (epicLinkField != null && (epicLinkObject = issue.getCustomFieldValue(epicLinkField)) != null) {
            epicLink = "" + epicLinkObject;
        }
        return epicLink;
    }

    private static Double getStoryPoints(Issue issue, CustomField storyPointField) {
        Object storyPointObject;
        Double retVal = null;
        if (storyPointField != null && (storyPointObject = issue.getCustomFieldValue(storyPointField)) != null) {
            retVal = (Double)storyPointObject;
        }
        return retVal;
    }

    private static List<VersionData> getFixVersions(Issue issue) {
        ArrayList retVal = Lists.newArrayList();
        for (Version version : issue.getFixVersions()) {
            retVal.add(new VersionData.Impl(version.getId(), version.getName()));
        }
        return retVal;
    }
}

