/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.Estimates;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.PlanInformation;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.PortfolioToJiraSyncData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.StageInformation;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.SyncTaskFactory;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.TimeEstimateSyncTask;
import com.radiantminds.roadmap.jira.common.components.issues.sync.SyncTask;

class TimeEstimateSyncTaskFactory
implements SyncTaskFactory {
    private final StageInformation stageInformation;
    private final PlanInformation planInformation;
    private final boolean legacyTimeTrackingMode;

    public TimeEstimateSyncTaskFactory(StageInformation stageInformation, PlanInformation planInformation, boolean legacyTimeTrackingMode) {
        this.stageInformation = stageInformation;
        this.planInformation = planInformation;
        this.legacyTimeTrackingMode = legacyTimeTrackingMode;
    }

    @Override
    public Optional<SyncTask> createTask(PortfolioToJiraSyncData data, Optional<IStage> stage) {
        if (data.getRemainingEstimates().isPresent()) {
            Optional<Double> remainingEstimatesSum = Estimates.toEstimateSum(data.getRemainingEstimates(), stage, this.stageInformation);
            Optional<Double> originalEstimatesSum = Estimates.toEstimateSum(data.getOriginalEstimates(), stage, this.stageInformation);
            return Optional.of((Object)new TimeEstimateSyncTask((Double)remainingEstimatesSum.get(), originalEstimatesSum, this.planInformation.getPlanningUnit(), this.planInformation.getHoursPerDay(), this.legacyTimeTrackingMode));
        }
        return Optional.absent();
    }
}

